Ext.define('Academia.view.enquiry.student.StudentAddressFormWindow', {
	extend: 'Ext.window.Window',
	alias : 'widget.studentaddress',
	title : getCommonTranslation('ADDRESS_DETAILS'),
	modal: true,
	resizable: true,
	autoScroll: true,
	frame: true,
	width: 630,
	minHeight: 780,
	maxHeight : 780,
	items: [{
		xtype: 'form',
		id:'studentaddressId',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'hidden',
			name : 'addressId'
		},{
			xtype : 'hidden',
			name : 'version'
		},{
			xtype : 'hidden',
			name : 'enquiryStudentDetailId'
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ADDRESS_TYPE'),
			name : 'addressType',
			itemId : 'addressTypeId',
			store:'organization.AddressTypeStore', 
			valueField : 'id',
			displayField : 'addressTypeName',
			allowBlank:false,
			forceSelection:true
			//editable : false
			/*hidden:true*/
		}, {
			xtype : 'textareafield',
			fieldLabel : getCommonTranslation('ADDRESS'),
			name : 'addressText',
			//vtype: 'NospaceAsInput',
			allowBlank:false,
			width: 536,
			maxLength:255,
            enforceMaxLength : true,
            listeners: {
            	blur: function(field, newValue, oldValue, eOpts){
            		field.setValue(field.getValue().trim());
            	}
            }
		},{
		    xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
	        		xtype : 'customcombobox',
	        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
	        		hiddenName : 'country',
	        		itemId : 'countryId',
	        		store:'common.CountryStore',
	        		valueField : 'id',
	        		displayField : 'countryName',
	        		name : 'country',
	        		//editable : false,
	        		valueNotFoundText:"",        		        						
					forceSelection :true,
					queryParam:'countryName',
					allowBlank:false,
					typeAhead : true,
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					hideTrigger:false,
					listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{countryName}'  +
			                    '</div>';
			                }
			            }
	        	},{
	        		xtype : 'customcombobox',
	        		fieldLabel : getCommonTranslation('COUNTRY_REGION'),
//	        		name : 'genericField1',
	        		itemId : 'parentCountryRegionId',
	        		store:'organization.CountryRegionStore',
	        		valueField : 'id',
	        		displayField : 'countryRegionName',
	        		name : 'parentCountryRegion',
	        		//editable : false,
	        		valueNotFoundText:"",     
	        		queryParam:'regionName',
					forceSelection :true,
					allowBlank:false,
					typeAhead : true,
					hideTrigger:false,
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{countryRegionName}'  +
			                    '</div>';
			                }
			            }
	        	}]
		}, {
		    xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [{
	    		xtype : 'customcombobox',
	    		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
	    		hiddenName : 'city',
	    		itemId : 'cityId',
//	    		store:'organization.CityStore',
	    		store:'organization.CityByCountryRegion',
	    		valueField : 'id',
//	    		displayField : 'cityName',
	    		displayField : 'value',
	    		queryParam:'name',
	    		name : 'city',
	    		//editable : false,    
	    		valueNotFoundText:"",        		
				forceSelection :true,
				allowBlank:false,
				typeAhead : true,
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	    	},{
	    		xtype : 'textfield',
	    		fieldLabel : getCommonTranslation('PINCODE'),
//	    		hiddenName : 'pincode',
	    		itemId : 'pincodeId',
	    		name : 'pincode',
	    		minValue : 0,
	    		maxLength: 8,
	    		maskRe:/^[a-zA-Z0-9\s]+$/,
	      	    mouseWheelEnabled :false,
	      	    hideTrigger :true,
	      	    allowExponential:false,
	      	    allowDecimals:false,
//				allowBlank:false
	    	}]
		    },{
			xtype: 'fieldset',
			 width: '536',
			 style:{'margin-top':'0px !important','padding':'0px !important','border':'0px !important'},
			itemId : 'contactFieldSet',
			defaults: {
				labelAlign: 'top',
			},
			// V2D-98400
//			title: getAdmissionTranslation('CONTACT_INFORMATION'), // Contact Information
			items: [/*{
				html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>',
				margin: 0
			},*/{
			xtype: 'fieldcontainer',
		    width: '536',
			fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
			//allowBlank:false,
			layout : {
				type : 'hbox'
			},
			defaults: {
				enforceMaxLength : true,
				labelAlign: 'top',
				width: 256
				//cls:'inputInRow'
			},
			items : [ {
				xtype : 'customcombobox',
				hiddenName : 'phoneNumber1',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:'common.CountryStore',
				queryMode: 'local',
				triggerAction : 'all',
				name : 'phoneCountryCode',
				itemId : 'phoneCountryCode',
				editable : false,			
				width: 108
			}, {
				xtype : 'numberfield',
				name : 'AreaCode',
				name : 'phoneAreaCode',
				width: 108,
				maxLength: 5,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
		        hideTrigger: true,
		        keyNavEnabled: false,
		        mouseWheelEnabled: false,
		        allowExponential:false
			}, {
				xtype : 'numberfield',
				itemId : 'phoneNoField',
				name : 'phoneNo',
				//maxLength: 10,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
		        hideTrigger: true,
		        keyNavEnabled: false,
		        mouseWheelEnabled: false,
		        allowExponential:false
			} ]
		}, {
		    	xtype: 'fieldcontainer',
			    width: '100%',
		    	fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
			defaults: {
				enforceMaxLength : true,
				labelAlign: 'top',
				width: 256
			},
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'customcombobox',
				name : 'cellCountryCode',
				itemId : 'cellCountryCode',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:'common.CountryStore',
				queryMode: 'local',
				triggerAction : 'all',
				editable : false,
				width: 108
			}, {
				xtype : 'numberfield',
				name : 'cellNo',
				itemId: 'cellNo',
				minLength: 0,
				maxLength: 11,
				// To Remove spinner buttons, and arrow key and mouse wheel listeners
		        hideTrigger: true,
		        keyNavEnabled: false,
		        mouseWheelEnabled: false,
		        allowExponential:false
			} ]
		}]
		}, {
			xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [ {
	            		xtype : 'textfield',
	            		fieldLabel : getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
	            		name : 'primaryeEmailId',
	            		vtype: 'email' 
//	            		allowBlank: false
	            	}, {
	            		xtype : 'textfield',
	            		fieldLabel : getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
	            		name : 'alternateEmailId',
	            		vtype: 'email',
	            		allowBlank: true
	            	}]
		},{	
			 xtype : 'fieldcontainer',
 			width : 'auto',
 			cls : 'windowBtnPos',
 			style:{
 				 'margin-top': '0px !important'
 			},
 			items : [{

					xtype: 'button',
					action: 'Submit',
					text: getCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'studentWin_submitbuttonId',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
			      },{
					xtype: 'button',
					text: getCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'studentWin_cancelbuttonId',
					scale: CONSTANTS.BUTTONSIZE
		    	  }]	
		   }]
	}]
});
