/**
 * Rajkumar
 * Bhanu
 */

Ext.define('Academia.view.enquiry.student.StudentDetailForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.ENQ_STUDENT_DETAIL_CUSTOM_FIELD,
	columns: 3,
	alias: 'widget.studentdetailform',
	autoScroll: false,
	frame: false,
	border:false,
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	cls: 'x-form-fixed-footer-parent',
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top'
		},
		items:[{
			xtype: 'hidden',
			id:'studentDetails_id',
			name: 'id'
		},{
			xtype: 'nestedTextField',
			id:'studentDetails_enquiryId',
			hidden:true,
			name: 'enquiry'
		},{
			xtype:'hidden',
			id:'studentDetails_addressId',
			name:'addressId'
		},{
			xtype:'hidden',
			id:'studentDetails_enquiryAddressId',
			name:'enquiryAddressId'	  
		},{
			xtype: 'customcombobox',
			name: 'registeredByType',
			id:'studentDetails_registeredByType',
			fieldLabel: getEnquiryTranslation('ENQUIRY_REGISTERED_BY'),
			store: 'enquiry.EnquiryRegisteredBy',
			valueField: 'id',
			displayField: 'value',
			editable: false
		},{
			xtype: 'customcombobox',
			name: 'enqRegByStudent',
			id:'studentDetails_enqRegByStudent',
			itemId:'enqRegByStudent',
			store: 'enquiry.ReferredStudentId',
			valueField: 'studentId',
			displayField: 'printName',
			fieldLabel: getCommonTranslation('STUDENT_ID_STUDENT_NAME'),
			editable: false
		},{
			xtype: 'nestedJsonCombo',
			name: 'reservationCategory',
			id:'studentDetails_reservationCategory',
			fieldLabel: getEnquiryTranslation('RESERVATION_CATEGORY'),
			store: 'enquiry.studentDetail.ReservationCategoryStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: false,
			forceSelection: true
		},{
            xtype: 'nestedJsonCombo',
            fieldLabel: getEnquiryTranslation('SALUTATION'),
            id:'studentDetails_salutation',
            name: 'salutation',
            store: 'common.SalutationStore',
            valueField: 'id',
            displayField: 'salutationName',
            allowBlank: false,
            editable: false,
            forceSelection: true
        }]
	}, {
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top',
			//regex: /[a-zA-Z0-9]+/
		},
		items:[{        	
			xtype: 'textfield',
			name: 'studentFirstName',
			id:'studentDetails_studentFirstName',
			allowBlank: false,
			fieldLabel: getEnquiryTranslation('STUDENT_FIRST_NAME'),
			maxLength:100,
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'studentMiddleName',
			id:'studentDetails_studentMiddleName',
			fieldLabel: getEnquiryTranslation('STUDENT_MIDDLE_NAME'),
			maxLength:53,
			enforceMaxLength : true
		},{

			xtype: 'textfield',
			name: 'studentLastName',
			id:'studentDetails_studentLastName',
			allowBlank:false,
			fieldLabel: getEnquiryTranslation('STUDENT_LAST_NAME'),
			maxLength:100,
			enforceMaxLength : true,
			//regex: /[a-zA-Z0-9\.]+/
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top',
		},
		items:[{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
			name: 'studentFirstNameOtherLanguage',
			itemId:'studentFirstNameOtherLanguageItemId',
			maxLength : 100,
			enforceMaxLength :true,
		},{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
			name: 'studentMiddleNameOtherLanguage',
			itemId:'studentMiddleNameOtherLanguageItemId',
			maxLength : 53,
			enforceMaxLength :true,
		},{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
			name: 'studentLastNameOtherLanguage',
			itemId: 'studentLastNameOtherLanguageItemId',
			maxLength : 255,
			enforceMaxLength :true,
		}]
	},{

		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{
			xtype: 'textfield',
			fieldLabel: getAdmissionTranslation('EMAIL_ADDRESS'),
			name: 'emailId',
			vtype: 'email',
			itemId: 'stdEmailId',
			maxLength: '100',
			allowBlank: true
		},{
			xtype: 'fieldcontainer',
			itemId : 'mobileNoFldItemId',
			fieldLabel: getCommonTranslation('MOBILE_NUMBER'),
			allowBlank: true,
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'mobileCountryCode',
				itemId: 'stdCountryCodeItemId',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: 'common.CountryStore',
				triggerAction: 'all',
				//editable: false,
				forceSelection: true,
				minChars: 1,
				allowBlank: true,
				width: 63,
				labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
			}, {
				xtype: 'numberfield',
				name: 'mobileNumber',
				itemId: 'stdMobileNumberItemId',
				minLength: 0,
				maxLength: 15,
				enforceMaxLength: true,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential: false,
				allowBlank: true,
				width: 153,
				labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
			}]
		},{
			xtype: 'fieldcontainer',
			itemId : 'alternateMobileNoFldItemId',
			fieldLabel: getEnquiryTranslation('ALTERNATE_NUMBER'),
			allowBlank: true,
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'alternateMobileCountryCode',
				itemId: 'stdAlternateMobileCountryCode',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: 'common.CountryStore',
				triggerAction: 'all',
				//editable: false,
				forceSelection: true,
				minChars: 1,
				allowBlank: true,
				width: 63,
				labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
			}, {
				xtype: 'numberfield',
				name: 'alternateMobileNo',
				itemId: 'stdAlternateMobileNo',
				minLength: 0,
				maxLength: 15,
				enforceMaxLength: true,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential: false,
				allowBlank: true,
				width: 153,
				labelStyle: 'height: 0px; overflow: hidden;width: 0px;margin-top: -4px;'
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top',
			//regex: /[a-zA-Z0-9]+/
		},
		items:[{
				xtype: 'datefield',
				name: 'studentDateOfBirth',
				id:'studentDetails_studentDateOfBirth',
				itemId:'studentDetails_studentDateOfBirth',
				maxValue : new Date(),
				fieldLabel:getEnquiryTranslation('DATE_OF_BIRTH'),
				//--submitFormat: 'd-m-Y',// CONSTANTS.DATE_FORMAT,
	            	listeners: {
	            		render: function(field) {
	            			return dateFormatRender(field);
	            		},
	                	change : function(date){
	                		var calcAge = date.up('form').getForm().findField('ageAsOnBirthDate');
	                       // console.log('calcAge....',calcAge);
	                         var today = new Date();
	                         var birthDate = new Date(date.lastValue);
	                         var age = today.getFullYear() - birthDate.getFullYear();
	                         var dobMonth = birthDate.getMonth();
	                         var tillDtMonth = today.getMonth();
	                         var month;
	                         if(tillDtMonth<dobMonth){
	                        	 age--;
	                        	 month=12-(dobMonth-tillDtMonth);
	                         }else if (tillDtMonth>dobMonth){
	                        	 month=tillDtMonth-dobMonth;
	                         }else{
	                        	 month=0;
	                         }
	                        	 calcAge.setValue(age + ' Year'+' '+ month +' Months');
	                	}
	                }
			},{
				xtype: 'textfield',
				fieldLabel: getEnquiryTranslation('PRESENT_AGE'),
				itemId: 'ageAsOnBirthDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
				name: 'ageAsOnBirthDate',
				editable: false,
				readOnly:true,
				disabled:true,
				
			},{  
				xtype: 'customcombobox',
				name: 'gender',
				id:'studentDetails_gender',
				store: 'common.GenderTypeStore',
				fieldLabel: getEnquiryTranslation('GENDER'),
				editable: false,
				valueField: 'id',
				displayField: 'value',
				readOnly : true
				//allowBlank: false
		},]

	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top'
		},
		items:[{
    				xtype: 'customcombobox',
    				name: 'currentGrade',
    				itemId: 'currentGradeItemId',
    				store: 'enquiry.EnquiryCurrentGradeStore',
    				fieldLabel: getEnquiryTranslation('CURRENT_GRADE'),
    				valueField: 'id',
    				displayField: 'value',
    				allowBlank: true,
    				forceSelection: true,
    				editable: false
    			},{
     				xtype: 'nestedJsonCombo',
    	            itemId: 'examBoardItemId',
    	            fieldLabel: getPersonModuleTranslation('EXAM_BOARD'),
    	            store: 'common.ExamBoardStore',
    	            valueField: 'id',
    	            displayField: 'value',
    	            name: 'examBoard',
    	            editable : false,
    	            allowBlank:true,
    	            hideTrigger:false,
    	            triggerAction: 'all',
    	            forceSelection:true
    			},{
    				xtype: 'multiselectcombofield',
    				name: 'enquiryStudentSchoolSubject',
    				itemId:'enquiryStudentSchoolSubjectItemId',
    				store: Ext.create('Academia.store.common.EducationHistorySubjectStore'),
    				allowBlank:true,
    				fieldLabel: getEnquiryTranslation('SCHOOL_SUBJECTS'),
    				valueField: 'id',
    				displayField: 'value',
    				editable: false,
    	            disableKeyFilter: false,
    	            cls:'commonAutoHeightMultiselectField',
    				forceSelection:true
    			}]    
    			},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top',
			//regex: /[a-zA-Z0-9]+/
		},
		items:[{
    				xtype: 'numberfield',
    				name: 'gradeElevenAverage',
    				itemId:'gradeElevenAverageItemId',
    				fieldLabel: getEnquiryTranslation('GRADE_ELEVEN_AVERAGE'),
    				hideTrigger:true,
    				mouseWheelEnabled:false,
    				regex: /[a-zA-Z0-9]+/,
    				allowDecimals:false,
    				minValue:0,
    				maxValue:100,
    				maxLength: 3,
    			},{
    				xtype: 'numberfield',
    				name: 'gradeTwelveAverage',
    				itemId:'gradeTwelveAverageItemId',
    				fieldLabel: getEnquiryTranslation('GRADE_TWELVE_AVERAGE'),
    				hideTrigger:true,
    	     	    mouseWheelEnabled:false,
    	     	    allowDecimals:false,
    	     	    regex: /[a-zA-Z0-9]+/,
    	     	    minValue:0,
    	     	    maxValue:100,
    	     	    maxLength: 3,
        			disabled:true   			
	},{
		xtype: 'customcombobox',
		name: 'bloodGroup',
		id:'studentDetails_bloodGroup',
		store: 'enquiry.studentDetail.BloodGroupStore',
		fieldLabel: getEnquiryTranslation('BLOOD_GROUP'),
		editable: false,
		valueField: 'value',
		displayField: 'value',
		forceSelection:true,
		itemId: 'bloodGroup'
	},{
		xtype: 'customcombobox',
		name: 'incomeSlabs',
		id:'studentDetails_incomeSlabs',
		store: 'enquiry.studentDetail.IncomeSlabStore',
		fieldLabel: getEnquiryTranslation('FAMILY_INCOME'),
		editable: false,
		valueField: 'id',
		displayField: 'value',
	    forceSelection:true,
		itemId: 'incomeSlab' 
	}],
	},{
    	xtype: 'fieldcontainer',
    	width: '100%',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 256,
    		labelAlign:'top'
    	},
    	items:[{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('COUNTRY'),
			name: 'country',
			autoload: false,
			itemId: 'countryItemId',
			store: 'common.CountryStore',
			valueField: 'id',
			displayField: 'countryName',
			queryParam:'countryName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		}, {
    		xtype: 'customcombobox',
    		fieldLabel: getEnquiryTranslation('NATIONALITY'),
    		itemId: 'nationalityCombo',
    		store: 'common.NationalityStore',
    		valueField: 'id',
    		displayField: 'value',
    		name: 'nationality',
    		queryMode: 'local',
    		autoload: false,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			anyMatch:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
    	},{
    		xtype : 'radiogroup',
    		fieldLabel : getCommonTranslation('IS_ENQ_STUDENT_SA_CITIZEN'),
    		itemId: 'stdIsLearnerSACitizenItemId',
    		name: 'stdIsLearnerSACitizenItemId',
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items:[{ 
    			boxLabel: getCommonTranslation('YES'), 
    			name: 'isLearnerSACitizen', 
    			inputValue: true,
    			checked:true
    		},{ 
    			boxLabel: getCommonTranslation('NO'), 
    			name: 'isLearnerSACitizen', 
    			inputValue: false
    		}]
    	},{
			xtype: 'textfield',
			name: 'nationalId',
			itemId:'stdNationalId',
			fieldLabel: getEnquiryTranslation('NATIONAL_ID_NUMBER'),
			maxLength: 50,
		   // vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput'
		}]
    
	}	,{	   
		xtype:'displayfield',
		value:'<b class="menu-title">'+getEnquiryTranslation('PARENTS_DETAILS')+'</b>',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top'
		},
		items:[{
			xtype: 'radiogroup',
			name: 'fatherOrganizationEmployee',
			itemId:'SD_radioBtn_F',
			id:'studentDetails_SD_radioBtn_F',
			fieldLabel: getEnquiryTranslation('FATHER_EMPLOYEE_OF_ORGANIZATION'),
			defaults: {
	            flex: 1
	        },
	        layout: 'hbox',
			items:[{ boxLabel: getCommonTranslation('YES'), name: 'fatherEmployed', inputValue: true },
			       { boxLabel: getCommonTranslation('NO'), name: 'fatherEmployed', inputValue: false,checked:true}
			]
		},{
			xtype: 'livesearchcombo',
			name: 'userByFatherEmployeeId',
			itemId:'studentDetails_memployeeIdF',
			fieldLabel: getEnquiryTranslation('ENQUIRY_EMPLOYEE_NAME'),
			minChars:3,
			hidden:true,
			typeAhead:false,
            hideTrigger:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
		}]
	},{
		xtype: 'fieldcontainer',
		itemId : 'fatherDetailsContainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top',
			// regex: /[a-zA-Z0-9]+/
		},
		items:[{        	
			xtype: 'customcombobox',
			name: 'fatherSalutationId',
			fieldLabel:getEnquiryTranslation('SALUTATION'),
			store: 'common.SalutationStore',
			queryMode: 'local',
			valueField: 'id',
			displayField: 'salutationName',
			width: 80,
			id:'studentDetails_father_salutation',
			editable: false,
			forceSelection: true
		},{
			xtype: 'textfield',
			name: 'fatherFirstName',
			itemId:'studentDetails_fatherFirstName',
			fieldLabel: getEnquiryTranslation('FATHER_FIRST_NAME'),
			//allowBlank: false,
			maxLength:35,
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'fatherMiddleName',
			itemId:'studentDetails_fatherMiddleName',
			fieldLabel: getEnquiryTranslation('FATHER_MIDDLE_NAME'),
			maxLength:35,
			enforceMaxLength : true

		},{        	   
			xtype: 'textfield',
			name: 'fatherLastName',
			itemId:'studentDetails_fatherLastName',
			fieldLabel: getEnquiryTranslation('FATHER_LAST_NAME'),
			//allowBlank: false,
			maxLength:35,
			enforceMaxLength : true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top'
		},
		items:[{
			xtype: 'radiogroup',
			name: 'motherOrganizationEmployee',
			itemId:'SD_radioBtn_M',
			id:'studentDetails_SD_radioBtn_M',
			fieldLabel: getEnquiryTranslation('MOTHER_EMPLOYEE_OF_ORGANIZATION'),
			defaults: {
	            flex: 1
	        },
	        layout: 'hbox',
			items:[{ boxLabel: getCommonTranslation('YES'), name: 'motherEmployed', inputValue: true },
			       { boxLabel: getCommonTranslation('NO'), name: 'motherEmployed', inputValue: false,checked:true}
			]
		},{
			
			xtype: 'livesearchcombo',
			name: 'userByMotherEmployeeId',
			itemId:'studentDetails_memployeeIdM',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hidden:true,
			fieldLabel: getEnquiryTranslation('ENQUIRY_EMPLOYEE_NAME'),
			minChars:3,
			typeAhead:false,
            hideTrigger:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			labelAlign:'top',
			//regex: /[a-zA-Z0-9]+/
		},
		items:[{        	
			xtype: 'customcombobox',
			name: 'motherSalutationId',
			fieldLabel:getEnquiryTranslation('SALUTATION'),
			store: 'common.SalutationStore',
			queryMode: 'local',
			valueField: 'id',
			id:'studentDetails_mother_salutation',
			displayField: 'salutationName',
			width: 80,
			editable: false,
			forceSelection: true
		},{
			xtype: 'textfield',
			name: 'motherFirstName',
			itemId:'studentDetails_motherFirstName',
			fieldLabel: getEnquiryTranslation('MOTHER_FIRST_NAME'),
			//allowBlank: false,
			maxLength:35,
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'motherMiddleName',
			itemId:'studentDetails_motherMiddleName',
			fieldLabel: getEnquiryTranslation('MOTHER_MIDDLE_NAME'),
			maxLength:35,
			enforceMaxLength : true
		},{     
			xtype: 'textfield',
			name: 'motherLastName',
			itemId:'studentDetails_motherLastName',
			fieldLabel: getEnquiryTranslation('MOTHER_LAST_NAME'),
			//allowBlank: false,
			maxLength:35,
			enforceMaxLength : true

		}]
	},{ 
		xtype:'displayfield',
		value:'<b class="menu-title">'+getEnquiryTranslation('SIBLLINGS_DETAILS')+'</b>',
		style: {
			textDecoration: "underline"
		}
	},{
		xtype: 'radiogroup',
		//width: 300,
		defaults: {
            flex: 1
        },
        layout: 'hbox',
		name: 'organizationsiblling',
		itemId:'SD_radioBtn_orgSiblling',
		id:'studentDetailForm_whetherSiblingStudying_ID',
		fieldLabel: getEnquiryTranslation('SIBLLING_STUDYING_ORGANIZATION'),
		items:[{ boxLabel: getCommonTranslation('YES'), name: 'whetherSiblingStudying', inputValue: true},
		       { boxLabel: getCommonTranslation('NO'), name: 'whetherSiblingStudying', inputValue: false,checked:true}
		]
	},{	
		xtype: 'fieldcontainer',
		itemId:'siblingDetailsComponent',
		hidden:true,
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			xtype: 'customcombobox',
			labelAlign:'top'
		},
		items:[{
			id:'studentDetails_addmissionIdofsiblling1',
			name: 'sibilingUser1',
			itemId:'studentSibling1',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			fieldLabel:getEnquiryTranslation('USER_ID_OF_SIBLLING_1'),
			store: 'enquiry.ReferredIdStore2',
			queryParam:'name',
			displayField: 'valueCode',
			valueField: 'id',
			queryParam:'name',
			typeAhead:false,
			forceSelection:true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
			id:'studentDetails_addmissionIdofsiblling2',
			name: 'sibilingUser2',
			itemId:'studentSibling2',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			fieldLabel:getEnquiryTranslation('USER_ID_OF_SIBLLING_2'),
			store: 'enquiry.ReferredIdStore3',
			queryParam:'name',
			displayField: 'valueCode',
			valueField: 'id',
			queryParam:'name',
			typeAhead:false,
			forceSelection:true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
			
		},{
			id:'studentDetails_addmissionIdofsiblling3',
			name: 'sibilingUser3',
			itemId:'studentSibling3',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			fieldLabel:getEnquiryTranslation('USER_ID_OF_SIBLLING_3'),
			store: 'enquiry.ReferredIdStore4',
			queryParam:'name',
			valueField: 'id',
			displayField: 'valueCode',
		    queryParam:'name',
		    typeAhead:false,
			forceSelection:true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		
		}]  

	},
	{
		xtype:'displayfield',
		id:'otherDetailsId',
		fieldLabel:getEnquiryTranslation('OTHER_DETAILS'),
		name:'otherDetails',
	},	
	{	
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			xtype: 'customcombobox',
			labelAlign:'top'
		},
		items:[{
			xtype: 'radiogroup',
			//width: 300,
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			name: 'uwcBefore',
			itemId:'enq_radioBtn_uwcBefore',
			id:'whetherUwcBeforeId',
			fieldLabel: getEnquiryTranslation('UWC_BEFORE'),
			items:[{ boxLabel: getCommonTranslation('YES'), name: 'whetherUwcBefore', inputValue: true},
				{ boxLabel: getCommonTranslation('NO'), name: 'whetherUwcBefore', inputValue: false,checked:true}
			]
		},{
			xtype: 'textfield',
			id:'uwcBefore',
			itemId:'uwcBefore',
			name: 'uwcStudentId',
			hidden:true,
			fieldLabel:getEnquiryTranslation('STUDENT_ID_NUMBER'),
			maxLength:100,
			enforceMaxLength : true					
		}]
	},
	{
		
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 256,
			xtype: 'customcombobox',
			labelAlign:'top'
		},
		items:[{
			xtype: 'radiogroup',
			//width: 300,
			defaults: {
				flex: 1
			},
			layout: 'hbox',
			name: 'registeredBeforeSA',
			itemId:'enq_radioBtn_registeredBeforeSA',
			id:'whetherRegisteredBeforeSAId',
			fieldLabel: getEnquiryTranslation('REGISTERED_SA_UNIVERSITY_BEFORE'),
			items:[{ boxLabel: getCommonTranslation('YES'), name: 'whetherRegisteredBeforeSA', inputValue: true},
				{ boxLabel: getCommonTranslation('NO'), name: 'whetherRegisteredBeforeSA', inputValue: false,checked:true}
			]
		},{
			xtype: 'textfield',
			id:'registeredBeforeSA',
			itemId:'registeredBeforeSA',
			name: 'southAfricanStudentId',
			hidden:true,
			fieldLabel:getEnquiryTranslation('STUDENT_ID_NUMBER'),
			maxLength:100,
			enforceMaxLength : true					
		}]
	
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'button',
			text: getEnquiryTranslation('MANAGE_ADDRESS'),
			itemId: 'studentdetail_addressId',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			cls: 'btn-with-no-icon'
		}]	
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'form-fixed-footer',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getCommonTranslation('SAVE'),
			formBind:true,
			itemId: 'studentdetail_submitbuttonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId:'studentdetail_cancelbuttonId',
			scale: CONSTANTS.BUTTONSIZE,
			cls: 'btn-with-no-icon'
		}]
	}]
});