/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.eventlevelremark.ApplyALToRemarkWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.applyALToRemarkWindow',
    modal: true,
    overflowY: 'auto',
    title: getExaminationTranslation('APPLY_TO'),
    maxHeight: window.innerHeight - 150,
	width: '45%',
    resizable: false,
    layout: 'fit',
    cls: 'applyALToRemarkWindow',
    noFixFoooterWin: true,
    items: [{
    	xtype: 'grid',
    	store: 'exam.eventLevelRemark.RemarkALStore',
    	border: true,
    	autoScroll: false,
    	frame:false,
    	selType:'checkboxmodel',
    	viewConfig: {
    		stripeRows: CONSTANTS.STRIPEROWS
    	},
    	selModel: {
    		mode:'MULTI',
    		showHeaderCheckbox: true,
    		allowDeselect: false,
    		checkOnly : true
    	},
    	columns: [{
    		header: getExaminationTranslation('ACADEMY_LOCATION'),
    		dataIndex: 'academyLocationName',
    		flex:.9,
    		sortable:true
    	}],
    	tbar: [{	
    		xtype:'fieldcontainer',
    		layout : 'hbox',
    		cls:'windowBtnPos',
    		items:[{
    			xtype: 'button',
    			itemId: 'btnLinkAlItemId',
    			tooltip: getExaminationTranslation('SAVE'),
    			ui: 'CustomBtnSubmit',
    	        scale: CONSTANTS.BUTTONSIZE,
    			text:getExaminationTranslation('SAVE'),
    			cls: 'btn-with-no-icon',
    			style:{
    					marginRight:'10px !important;',
    					border: '1px solid #A3A3A3 !important;'
    			}
    		},{
    			xtype:'textfield',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			width: 300,
    			name:'academyLocation',
    			itemId:'academyLocationItemId',
    			cls: 'SearchTextFieldWithSmallHeader'
    		}]
    	}]
    }]
});