/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.eventlevelremark.MappedALToRemarkWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.mappedALToRemarkWindow',
    modal: true,
    overflowY: 'auto',
    title: getExaminationTranslation('MAPPED_ACADEMY_LOCATION'),
    maxHeight: window.innerHeight - 150,
    minHeight: 200,
	width: '45%',
    resizable: false,
    items: [{
    	xtype: 'grid',
    	store: 'exam.eventLevelRemark.MappedRemarkALStore',
    	border: true,
    	autoScroll: false,
    	frame:false,
    	isFixHeightGrid: true,
    	minHeight: 0,
    	tbar: [],
    	viewConfig: {
    		stripeRows: CONSTANTS.STRIPEROWS
    	},
    	columns: [{
    		header: getExaminationTranslation('MAPPED_ACADEMY_LOCATION'),
    		dataIndex: 'academyLocationName',
    		flex:.9,
    		sortable:true
    	}]
    }, {
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		scale : CONSTANTS.BUTTONSIZE,
    		cls: 'btn-with-no-icon',
    		listeners:{
    			click : function(btn){
    				btn.up('window').close();
    			}
    		}
    	}]
    }]
});