/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.eventmeetingminutes.EventMeetingMinutesDocumentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.eventmeetingminutesdocumentgrid',
    store: 'eventmeetingminutes.EventMeetingMinutesDocumentStore',
    border: true,
   // autoScroll: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    isFixHeightGrid: true,
    isFixWidthColums: true,
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('DOCMENT_NAME'),
        dataIndex: 'documentName',
        flex: 1,
        sortable:false,
        renderer: function(value, rec) {
            var id = rec.record.data.id;
            if (id != "" && id != undefined) {
                return '<a href="#">' + value + '</a>';
            } else {
                return value;
            }
        }
    }]
});