/**
 * @author Abhishek.Chouhan
 */
Ext.define('Academia.view.examcancellation.ExamCancellationApplyToWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.examcancellationapplytowindow',
	modal : true,
	resizable:false,
	autoScroll:false,
	title: getExaminationTranslation('APPLY_TO'),
	height: 320,
	width: 570,
	frame: true,
	items:[{
		xtype : 'form',
		defaults : {
			labelAlign : 'top',
			width: 256
		},
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 480
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'textfield',
				name : 'examCancellationName',
				allowBlank : true,
				fieldLabel : getExaminationTranslation('EXAM_CANCELLATION_NAME'),
				readOnly: true
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 480
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'textfield',
				name : 'academyLocationName',
				allowBlank : false,
				fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
				readOnly: true
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width: 230
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'textfield',
				name : 'programName',
				allowBlank : false,
				fieldLabel : getCommonTranslation('PROGRAM'),
				readOnly: true
			},{
				xtype : 'textfield',
				name : 'batchName',
				allowBlank : false,
				fieldLabel : getCommonTranslation('BATCH'),
				readOnly: true
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [{
				xtype : 'button',
				style:{
					marginTop: '10px'
				},
				itemId : 'applyToWindowCancelBtn',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
	}]
});