/**
 * Deepika P
 */

Ext.define('Academia.view.examconcession.AddExamConcessionForm',		{
	extend : 'Ext.form.Panel',
	alias : 'widget.addexamconcessionform',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
    autoScroll:false,
    items : [{
    	xtype : 'fieldcontainer',
    	layout : 'hbox',
    	defaults : {
    		labelAlign : 'top',
    		width: 256
    	},
    	layout : {
    		type : 'hbox'
    	},
    	items : [{
    		 xtype:'hidden',
    		 itemId:'examConcessionId',
    		 name:'examConcessionId'
    	} 	,{
    		xtype : 'textfield',
    		fieldLabel : getExaminationTranslation('EXAM_CONCESSION_CODE'),	
    		name : 'examConcessionCode',
    		itemId : 'examConcessionCodeId',
    		allowBlank:false,
    		allowOnlyWhitespace:false
    		
    	},{
    		xtype : 'textfield',
    		fieldLabel : getExaminationTranslation('EXAM_CONCESSION_NAME'),	
    		name : 'examConcessionName',
    		itemId : 'examConcessionNameId',
    		allowBlank:false,
    		allowOnlyWhitespace:false
    	}]
    },{
    	xtype : 'fieldcontainer',    	
    	width : '100%',
    	width: 'auto',
    	layout : {
    		type : 'hbox'
    	},    	
    	items : [{
			xtype: 'customcombobox',
    		width: 256,
			name:'examConcessionStatus',
			itemId:'examConcessionStatusId',
			fieldLabel: getCommonTranslation('STATUS'),
			displayField: 'value',
			valueField: 'id',
			labelAlign : 'top',
			hidden:true,			
			store:Ext.create('Academia.store.examconcession.ExamConcessionStatusStore'),
	
	},{
		    xtype: 'checkboxfield',
		    labelAlign: 'right',
			region: 'south',
			width:260,
			itemId : 'isDependentFieldRequiredId',
			boxLabel: getExaminationTranslation('DEPENDENT_FIELD_REQUIRED'),
			name: 'dependentFieldRequired',
			inputValue: true,
			uncheckedValue: false
			
			}]
    },{
    	xtype : 'fieldcontainer',
    	itemId:'dependentfieldcontainerId',
    	layout : 'hbox',
    	height:'auto',
    	hidden:true,
    	style:{
    		'margin-bottom': '-25px'
    	},
    	defaults : {
    		labelAlign : 'top',
    		width: '256'
    	},
    	items:[{
    		xtype:'panel',
    		itemId:'dependentfieldPanelId',
    		style:{
    			'margin-left': '0px',
    			'margin-top': '0px',
    			'top':'0px'
    		},
    		items:[{
    			xtype : 'fieldcontainer',
    			layout : 'hbox',
    			defaults : {
    				labelAlign : 'top',
    				width: '256'
    			},
    			items:[{
    				xtype: 'customcombobox',
    				width: 256,
    				name: 'dependentFieldType',
    				itemId:'dependentFldTypeId',
    				store: Ext.create('Academia.store.examconcession.ExamConcessionDependentFieldTypeStore'),
    				valueField: 'value',
    				displayField: 'value',
    	    		editable:false,
    				fieldLabel: getExaminationTranslation('DEPENDENT_FIELD_TYPE'),
    		    	
    			},{
    				xtype : 'textfield',
    	    		fieldLabel : getExaminationTranslation('DEPENDENT_FIELD_NAME'),	
    	    		name : 'dependentFieldName',
    	    		itemId : 'dependentFldNameId',   	    		
    				
    			},{
					xtype: 'hidden',
					itemId: 'dependentFldId',
					name:'dependentFldId',
				},{
    				xtype: 'button',
    				itemId: 'addDetailedBtn',
    				name: 'addDetailedBtn',
    				width: 'auto',
    				cls: 'CustomBodyBtnSettings',
    				width: 'auto',
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD'),
    				style:{
						marginTop:'30px !important'
					}
    				
    			}]
    		}]
    	}]
    },{
    		xtype : 'fieldcontainer',
    		cls : 'windowBtnPos',
    		items : [
    			{
    				xtype : 'button',
    				action : 'Submit',
    				text : getExaminationTranslation('SAVE'),
    				formBind : true,
    				itemId : 'SubmitBtn',
    				ui : 'CustomBtnSubmit',
    				scale : CONSTANTS.BUTTONSIZE
    			},
    			{
    				xtype : 'button',
    				text : getExaminationTranslation('CANCEL'),
    				ui : 'CustomBtnCancel',
    				itemId : 'CancelBtn',
    				scale : CONSTANTS.BUTTONSIZE
    			} ]
    	}]
	
		});