/**
 *  @author Deepika P
 * 
 */
Ext.define('Academia.view.examconcession.EConcessionAddMappingAcademyLocationTab' ,{
	extend: 'Ext.panel.Panel',
	alias : 'widget.econcessionaddmappingacademylocationtab',
    width:'100%',
	title: getCommonTranslation('ACADEMY_LOCATION'),
	autoScroll:true,
	bodyStyle:{
		border: 0
	},
	items:[{
		xtype:'label',
		itemId:'examConcessionLabelName',
		margin: 10
	},{
		xtype:'grid',
		title:getCommonTranslation('ACADEMY_LOCATION'),
		store: 'user.UserAcademyLocationStore',
		border: true,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType:'checkboxmodel',
		selModel: {
			checkOnly : false,
			multiSelect :true,
    	    mode: 'SIMPLE'
		},
		/*dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'user.UserAcademyLocationStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],*/
		tbar: [{
			xtype: 'button',
			itemId: 'academyLocationNextBtn',
			tooltip: getCommonTranslation('NEXT'),
			text:getCommonTranslation('NEXT'),
			disabled: true
		}, {
			xtype: 'button',
			itemId: 'academyLocationResetBtn',
			tooltip: getCommonTranslation('RESET'),
			text: getCommonTranslation('RESET')
		}, {
            xtype: 'customcombobox',
            name: 'ACAD_LOC_ID',
            itemId:'academyLocationCombo',
            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
            displayField: 'value',
            valueField: 'id',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: '',
            minChars:3,
            width: 256,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        }],
		columns :[{
			header : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'value',
			flex:1
		}]
	}]
});

