/**
 * @author Deepika P
 */
Ext.define('Academia.view.examconcession.ExamConcessionFilter', {
extend: 'Ext.form.Panel',
	alias: 'widget.examconcessionfilter',
	//autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'examConcessionCodeName',
			itemId:'examConcessionCodeNameId',
			store:Ext.create('Academia.store.examconcession.ExamConcessionCodeNameStore'),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:false,
			fieldLabel:getExaminationTranslation('EXAM_CONCESSION_CODE_NAME'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		    hideTrigger:false,
		    queryParam:'examConcessionName',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
				xtype: 'customcombobox',
        		width: 256,
				name:'examConcessionStatus',
				itemId:'examConcessionStatusId',
				fieldLabel: getCommonTranslation('STATUS'), 
				displayField: 'value',
				forceSelection:true,   // V2D-405136
				valueField: 'id',
				store:Ext.create('Academia.store.examconcession.ExamConcessionStatusStore'),
		
		}]
	},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'examConcessionProgram',
				itemId:'examConcessionProgramId',
				store:Ext.create('Academia.store.examconcession.ExamConcessionProgramStore'),
				valueField: 'id',
				displayField: 'value',
				fieldLabel:getExaminationTranslation('PROGRAM'),
				forceSelection:true,
				enableKeyEvents  : 'true',
				typeAhead:false,
				minChars:3,
				width: 536,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			    hideTrigger:false,
			    queryParam:'name',
				listConfig: { 
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
				
			},{
				xtype: 'customcombobox',
        		width: 256,
				name:'examConcessionBatch',
				itemId:'examConcessionBatchId',
				fieldLabel: getExaminationTranslation('BATCH'),
				displayField: 'value',
				valueField: 'id',
				disabled:true,
				store:Ext.create('Academia.store.examconcession.ExamConcessionBatchStore'),
		
			}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'examConcessionSearchId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'examConcessionResetId',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
