/**
 * Application Details (Register for Assessment Group)
 */
Ext.define('Academia.view.examexecution.RegGroupApplyWindow', {
    extend: 'Ext.form.Panel',
    alias: 'widget.reggroupapplywindow',

    bodyPadding: 10,
    scrollable: true,
    layout: 'anchor',

    initComponent: function () {
        var me = this;

        Ext.apply(me, {
            defaults: {
                anchor: '100%'
            },

            items: [

                /** -------------------------------
                 *  FORM SECTION
                 *  -------------------------------- */
                {
                    xtype: 'form',
                    itemId: 'applyDetailsForm',
                    border: false,
                    layout: 'column',
                    bodyPadding: 0,

                    defaults: {
                        xtype: 'textfield',
                        labelAlign: 'top',
                        width: 226,
                        margin: '5 10 5 0'
                    },

                    items: [
                        { fieldLabel: 'Admission ID/Student Name', name: 'studentName' },
                        { fieldLabel: 'Name', name: 'name' },
                        { fieldLabel: 'Assessment Group Name', name: 'assessmentGroupName' },
                        { fieldLabel: 'Assessment Group Status', name: 'groupStatus', readOnly: true },
                        { fieldLabel: 'Center Status', name: 'centerStatus', readOnly: true },
                        { fieldLabel: 'Program', name: 'program', readOnly: true },
                        { fieldLabel: 'Batch', name: 'batch', readOnly: true },
                        { fieldLabel: 'Application Status', name: 'applicationStatus', readOnly: true },
                        { fieldLabel: 'Room Allocation Status', name: 'roomAllocationStatus', readOnly: true }
                    ]
                },



                /** -------------------------------
                 *  GRID SECTION
                 *  -------------------------------- */
                {
                    xtype: 'reggroupapplyeventgrid',
                    itemId: 'reggroupapplyeventgrid',
                    title: getMegaMenuTranslation('EVENT_AVAILABLE_FOR_STUDENT'),
                    margin: '10 0 0 0'
                },



                /** -------------------------------
                 *  BUTTON SECTION
                 *  -------------------------------- */
                {
                    xtype: 'fieldcontainer',
                    layout: 'hbox',
                    margin: '10 0 0 0',
                    items: [{
                        xtype: 'button',
                        itemId: 'submitBtn',
                        text: getCommonTranslation('SAVE'),
                        ui: 'CustomBtnSubmit',
                        scale: CONSTANTS.BUTTONSIZE,
                        formBind: true
                    }]
                }
            ]
        });

        me.callParent(arguments);
    }
});
