/**

 *  @author Vinay Kumrawat
 * 
 */
var alProgramBatchListStore = Ext.create('Academia.store.feeandpayment.ALProgramBatchList')
Ext.define('Academia.view.examinationattendancerule.AttendanceAddMappingProgramBatchTab' ,{
	extend: 'Ext.panel.Panel',
	alias : 'widget.attendanceaddmappingprogrambatchtab',
    width:'100%',
	title: getCommonTranslation('PROGRAM_BATCH'),
	autoScroll:false,
	bodyStyle:{
		border: 0
	},
	items:[{
		xtype:'label',
		itemId:'attendanceRuleNameLabel',
		margin: 10
	},{
		xtype:'grid',
		title:getCommonTranslation('PROGRAM_BATCH'),
		store: alProgramBatchListStore,
		border: true,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType:'checkboxmodel',
		selModel: {
			checkOnly : false,
			multiSelect :true,
    	    mode: 'SIMPLE'
		},
		tbar: [{
			xtype: 'button',
			itemId: 'batchSubmitBtn',
			tooltip: getExaminationTranslation('SUBMIT'),
			text:getExaminationTranslation('SUBMIT'),
			disabled: true
		}, {
			xtype: 'button',
			itemId: 'batchResetBtn',
			tooltip: getCommonTranslation('RESET'),
			text: getCommonTranslation('RESET')
		}, {
            xtype: 'customcombobox',
            itemId:'batchCombo',
            store: Ext.create('Academia.store.feeandpayment.ALProgramBatchList'),
            displayField: 'batchName',
            valueField: 'batchId',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
            queryMode: 'remote',	 
    	    triggerAction: '',
    	    queryParam: 'qry',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            width: 256,
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        }],
		columns :[{
			header : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			flex:1
		},{
			header : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			flex:1
		},{
			header : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex:1
		}],
		dockedItems: [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [ {
				xtype : 'custompagingtoolbar',
				plugins:['pagesize'],
				store : alProgramBatchListStore,
				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				displayInfo : true
			} ]
		}]
	}]
});

