/**
 *  @author Vinay Kumrawat
 * 
 */
Ext.define('Academia.view.examinationattendancerule.AttendanceAddMappingProgramTab' ,{
	extend: 'Ext.panel.Panel',
	alias : 'widget.attendanceaddmappingprogramtab',
    width:'100%',
	title: getCommonTranslation('PROGRAM'),
	autoScroll:false,
	bodyStyle:{
		border: 0
	},
	items:[{
		xtype:'label',
		itemId:'attendanceRuleNameLabel',
		margin: 10
	},{
		xtype:'grid',
		title:getCommonTranslation('PROGRAM'),
		store: Ext.create('Academia.store.facilitiesresources.resourcemaster.ProgramGridStore'),
		border: true,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType:'checkboxmodel',
		selModel: {
			checkOnly : false,
			multiSelect :true,
    	    mode: 'SIMPLE'
		},
		tbar: [{
			xtype: 'button',
			itemId: 'programNextBtn',
			tooltip: getCommonTranslation('NEXT'),
			text:getCommonTranslation('NEXT'),
			disabled: true
		},{
			xtype: 'button',
			itemId: 'programSubmitBtn',
			tooltip: getExaminationTranslation('SUBMIT'),
			text:getExaminationTranslation('SUBMIT'),
			disabled: true
		}, {
			xtype: 'button',
			itemId: 'programResetBtn',
			tooltip: getCommonTranslation('RESET'),
			text: getCommonTranslation('RESET')
		}, {
            xtype: 'customcombobox',
            itemId:'programCombo',
            store: Ext.create('Academia.store.facilitiesresources.resourcemaster.ProgramGridStore'),
            displayField: 'value',
            valueField: 'id',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: '',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            width: 256,
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        }],
		columns :[{
			header : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'secondValue',
			flex:1
		},{
			header : getCommonTranslation('PROGRAM'),
			dataIndex : 'value',
			flex:1
		}]
	}]
});

