/**
 * Vinay Kumrawat
 *
 */
Ext.define('Academia.view.examinationattendancerule.AttendanceRuleForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.attendanceruleform',
	autoScroll:false,
	layout: 'vbox',
	method: 'POST',
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	standardSubmit : false,
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'hidden',
		name : 'id',
	  itemId: 'id',	
	},
{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 300
		},
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'textfield',
			name : 'attendanceRuleName',
			itemId: 'attendanceRuleNameId',
			allowBlank : false,
			fieldLabel : getExaminationTranslation('ATTENDANCE_RULE_NAME'),
			maxLength:100,
			allowOnlyWhitespace: false,
			maskRe:/[A-Za-z0-9_-\s]/,
    		listeners: {
    			render: function (field) {
                    field.getEl().on('paste', function () {
                        this.type = 'onpaste';
                    }, field);
                },
                change: function (field) {
                    if (field.type == 'onpaste' && field.maskRe) {
                        field.type = null;
                        var regex = new RegExp(field.maskRe.toString().replace('/[', '[^').replace(']/', ']').replace('[^^', '['), 'g');
                        field.setValue(field.getValue().replace(regex, ''));
                    }
                }
    		}
		}]
	}, {
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			itemId : 'attendanceRuleNameCancelBtn',
			text : getCommonTranslation('CANCEL'),
			ui : 'cancelbuttonClsPopUp',
			scale : CONSTANTS.BUTTONSIZE
		},{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'attendanceRuleNameSubmitBtn',
			ui : 'CustomBtnSubmit',
			cls:'CustomBtnSubmitToolbaar',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		} ]
	} ]

});