/**
 * @author 
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.DownloadAssessmentEventsFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.downloadassessmenteventsfilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evaluationType',
			itemId:'evaluationTypeItemId',
			store:'examCenter.AssignSequence.EvaluationType',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
		},{
			xtype: 'customcombobox',
			name:'evaluationStage',
			store:'examinationcenters.CenterUseFor',
			itemId:'evaluationStageItemId',
			fieldLabel: getExaminationTranslation('EVALUATION_STAGE'),
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
//			width: 536,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'downloadAssessmentEvaluationplan',
			itemId:'downloadAssessmentEvalautionPlanId',
			store:'examinationcenters.assessmentEvent.EvaluationPlanForDownloadEventStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 256,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}/*,
					select: function(combo, records){
						var form = combo.view.up().up('form');
						if(form.down('#downloadAssessmentEvalautionPlanId').getValue() && form.down('#downloadAssessmentEvalautionPlanId').getValue()){
							form.down('#assessmentEventDownload').setDisabled(false);
						}
					}*/
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}

		},{
        	xtype: 'hidden',
            name: 'evalPlanLevelType',
            itemId:'evalPlanLevelTypeItemId',
        },{
            xtype: 'groupingcombobox',
            name: 'downloadAssessmentEvalPlanLevelId',
            itemId:'downloadAssessmentEvalPlanLevelItemId',
            labelAlign:'top',
            queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store: 'examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId',
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            valueField: 'levelId' ,
            minChar : 3,
            width: 256,
            forceSelection:true,  //V2D-401618
            listeners:{
            	select:function(obj,rec){
            		var data=rec[0].data.code;
            		//obj.nextSibling().setValue(data);
            	}
            }
        }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'downloadAssessmentProgramId',
			itemId: 'downloadAssessmentProgramItemId',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'facilitiesresources.resourcemaster.ProgramsInEvluationPlanStore',
			displayField:'value',
			valueField:'id',
			maxLength:15000,
			autoloadStore: false,
//			allowBlank:false,
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
            xtype: 'customcombobox',
            name: 'downloadAssessmentBatchId',
            itemId: 'downloadAssessmentBatchItemId',
            store:'common.BatchesByProgramId',
            fieldLabel: getExaminationTranslation('BATCH'),
         // editable: false,
            allowBlank:true,
            disabled:true,
            queryParam:'batchName',
        //    queryMode: 'local',
            minChars:'3',
            typeAhead:true,
            forceSelection:true,
            displayField: 'value',
            valueField: 'id'
		},{
            xtype: 'customcombobox',
            name: 'downloadAssessmentPeriodId',
            itemId: 'downloadAssessmentPeriodItemId',
            store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
            fieldLabel: getExaminationTranslation('PERIOD'),
//           editable: false,
            disabled:true,
//            allowBlank:false,
            queryMode: 'local',
            minChars:'3',
            forceSelection:true,
            typeAhead:true,
            displayField: 'value',
            valueField: 'id',
            width: 256
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top',
			margin:'5px 5px 0px 0px'	
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'course',
			itemId:'courseItemId-downloadassessmenteventsfilter',
			store:'examinationcenters.assessmentEvent.CoursesForEvents',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			width: 536,
			queryMode: 'local',
			minChars:'3',
			autoloadStore: false,
//			for V2D-68384 bug
//			height:90,
			maxLength:9999,
			maxSelections :9999,
			allowBlank: false,
			editable:false,
			matchFieldWidth: false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			fieldLabel: getCommonTranslation('COURSE'),
			listeners: {
                afterrender: function(cmp) {
                    cmp.onTrigger1Click();
                }
            },
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					select: function(combo, records) {
					    var form = combo.view.up().up('form');
					    var selectedRecord = form.down('#downloadAssessmentEvalautionPlanId').getValue();

					    if(selectedRecord) {
					        form.down('#assessmentEventDownload').setDisabled(false);
					    } else {
					        form.down('#assessmentEventDownload').setDisabled(true);
					    }
					} 
				},
				loadingText: getCommonTranslation('SEARCHING'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype:'button',
			itemId:'assessmentEventDownload',
			disabled:true,
			text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
			ui: 'CustomBtnSubmit',
			formBind:true
		}, 
		{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
