/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.EventStudentFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.eventstudentfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programItemId',
			fieldLabel : getExaminationTranslation('PROGRAM'),
			store:'facilitiesresources.resourcemaster.ProgramGridStore',
			displayField:'value',
			valueField:'id',
			maxLength:15000,
			autoloadStore: false,
			allowBlank:false,
			height:'10px'
		},{
            xtype: 'customcombobox',
            name: 'BATCH_NAME',
            itemId: 'batchId',
            store:'common.BatchesByProgramId',
            fieldLabel: getExaminationTranslation('BATCH'),
            editable: false,
            allowBlank:false,
            disabled:true,
            queryMode: 'local',
            displayField: 'value',
            valueField: 'id'
		},{
            xtype: 'customcombobox',
            name: 'PERIOD_NAME',
            itemId: 'periodId',
            store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
            fieldLabel: getExaminationTranslation('PERIOD'),
            editable: false,
            disabled:true,
            allowBlank:false,
            queryMode: 'local',
            displayField: 'value',
            valueField: 'id',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
            xtype: 'customcombobox',
            name: 'section',
            itemId: 'sectionId',
            store:'program.programDetails.programBatches.courseParameter.SectionForEvent',
            fieldLabel: getExaminationTranslation('SECTION'),
            editable: false,
            width: 256,
            queryMode: 'local',
            displayField: 'value',
            valueField: 'id',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
        	xtype: 'customcombobox',
			name:'eligibleStudentCourseId',
			itemId:'eligibleStudentCourseItemId',
			store:'examinationcenters.assessmentEvent.StudentEligibleCoursesDynamicEvent',
			allowBlank:false,
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
        },{
			xtype: 'customcombobox',
			name:'eligibleStudentEvaluationplan',
			itemId:'eligibleStudentEvalautionPlanId',
			store:'examinationcenters.assessmentEvent.EligibleStudentsEvaluationPlanForEventStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 256,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'eligibleStudentDetailSequence',
			itemId:'eligibleStudentDetailSequenceItemId',
			store:'examinationcenters.manageEvaluation.EligibleStudentEvaluationEventByEvalPlan',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			allowBlank: false,
		},{
			xtype: 'hidden',
			name: 'selectedEventId',
			itemId:'selectedEventId',
		},{
			xtype: 'hidden',
			name: 'selectedId',
			itemId:'selectedId',
		},{
			xtype: 'hidden',
			name: 'examStatus',
			itemId:'examStatus',
		},{
	xtype: 'fieldcontainer',
	    			layout: 'hbox',
                    itemId: 'courseavgmarksorgradeItemId',
                    name: 'courseavgmarksorgradeItemId',   
					fieldLabel:getExaminationTranslation('Course Average Grade/Marks'),
					disabled:false,
					hidden:true,
					width:300,       
	    			//width:'100%',
					labelAlign: 'top',
					
	    			defaults: {
	    				//labelAlign: 'left',   
	    				width: 256  
	    			},
					 style:{
							    	 marginRight:'13px !important'
						          },
	    			items: [{  
					            xtype: 'numberfield',   
					            fieldLabel:getExaminationTranslation('Min Marks'),
					            itemId: 'minmarksItemId',  
					            name: 'minmarksItemId',
								width:150, 
								decimalPrecision:2,
								forceSelection: true,
								hideTrigger: true,
			                	mouseWheelEnabled:false,
			               		maxLength:5,
			                	minValue:0,
								maxValue:100,
								hidden:true, 
			               		allowExponential:false,
								labelAlign: 'left',
								labelWidth: 72   
        				},{  
				            xtype: 'numberfield',   
				            fieldLabel:getExaminationTranslation('Max Marks'),
				            itemId: 'maxmarksItemId',
				            name: 'maxmarksItemId',
							maxValue: 100,
							width:150, 
							decimalPrecision:2,
							forceSelection: true,
							hideTrigger: true,
		                	mouseWheelEnabled:false,
		               		maxLength:5,
		                	minValue:0, 
		               		allowExponential:false,
                			hidden:true,
							labelWidth: 72,   
							validator : function(val) {
								var minValueField =this.previousSibling();
								var minValue = minValueField
								.getValue();
								if (minValue != null) {
									if (val >= minValue) {
										minValueField
										.clearInvalid();
										return true;
									} else {
										return getCommonTranslation('LESS THAN MIN VALUE');
									}
								} else {
									return true;
								}
							      }   
				            
        			},
					{  
			            xtype:'customcombobox',
			            fieldLabel:getExaminationTranslation('Select Grade'),   
			            itemId: 'SelectGradeItemId',  
			            name: 'SelectGradeItemId',
	                    store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',    
						displayField:'gradeName',
						valueField:'gradeName',  
			            forceSelection:true,
						hideTrigger: true,  
						width:290, 
						labelAlign:'left',       
						hidden:true,
						typeAhead:false,
					    triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					    enableKeyEvents  : 'true',
					    hideTrigger:false,
					    forceSelection:true,
					    allowBlank:true,
							listConfig: {
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								},
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width-105;
									}
								}
							}   
			             }]
					}]
	},            
	{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'studentId',   
			itemId: 'studentItemId',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.EvalEligibleStudent',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			width: 536,
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
        },{
		            	xtype: 'customcombobox',
						name: 'academicstandingId',
						itemId: 'academicstandingId',
						fieldLabel:getExaminationTranslation('Academics Standing'),
						store:Ext.create('Academia.store.coursetransaction.promotion.PromotionListbyids'),    
						displayField:'value',  
		                valueField:'code',
						hidden:true,              
			        	minChars:3,
						width:290,           
			        	queryParam:'name',  
			        	emptyText: getCommonTranslation('ENTER_THREE_CHAR')    
						
			        }]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		style: {
			'margin-left': '-32px !important;'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'quickSearchId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:false  
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

//}]
});