/**
 * @pankaj Sisodiya
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.ManageAssessmentStatusGrid',{
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageAssessmentStatusGrid',
	store: 'examinationcenters.assessmentEvent.ManageAssessmentStatusStore',
	border: true,
	frame:false,
	title:getExaminationTranslation('MANAGE_EVALUATION_STATUS_LIST'),
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.assessmentEvent.ManageAssessmentStatusStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
		var grid=this;     
		
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActionsEvent',
		text : getExaminationTranslation('CHANGE_EVENT_STATUS'),
		menu:[{
			text:getExaminationTranslation('CNTRL_PENDING'),
			tooltip: getExaminationTranslation('STUDENT_MAPPING_ENABLE'),
			itemId:'btnPendingEvent'	
		},{
			itemId: 'btnOpenEvent',
			tooltip: getExaminationTranslation('OPEN_FOR_MARKENTRY'),
			text:getExaminationTranslation('OPEN_FOR_MARKENTRY'),
		},{
			text:getExaminationTranslation('COMPLETED_MARK_ENTRY'),
			tooltip: getExaminationTranslation('COMPLETED_MARK_ENTRY'),
			itemId:'btnCompletedEvent'
		}]
	}],
	columns: [{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.2,
		sortable: true
	},{
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable: true
	},{
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable: true
	},{
		header: getExaminationTranslation('EVALUATION_PLAN'),
		dataIndex: 'evaluationPlanName',
		flex:.1,
		sortable: true,
		hidden:true
	},{
		header: getExaminationTranslation('COURSE_ID_NAME'),
		dataIndex: 'courseName',
		flex:.2,
		sortable: true
	},{
		header: getExaminationTranslation('EVALUATION_TYPE'),
		dataIndex: 'evaluationPlanLevelOneName',
		flex:.1,
		sortable: true
	}, {
		header: getExaminationTranslation('EVALUATION_SUB_TYPE'),
		dataIndex: 'evaluationPlanLevelTwoName',
		flex:.1,
		sortable:true
	},{
		header: getExaminationTranslation('EVALUATION_METHOD_VALUE'),
		dataIndex: 'evaluationSequenceName',
		flex:.1,
		sortable:true
	},{
		header: getExaminationTranslation('EVALUATION_EVENT'),
		dataIndex: 'eventName',
		flex:.1,
		sortable:true
	},{
		header: getExaminationTranslation('EVENT_STATUS'),
		dataIndex: 'eventStatus',
		flex:.1,
		sortable:true,
	renderer:function(value){
		if(value=="PENDING"){
			return "Pending";

		}else if(value=="CLOSED"){
			return "<sapn style=\'color:red\'>Result Declared</span>";

		}else if(value=="CONDUCTED"){
			return "<sapn style=\'color:green\'>Open For Mark Entry</span>";

		}else{
			return value;
		}
	}
	},{
		header: getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTermName',
		flex:.1,
		sortable:true,
		hidden:true
	}]
});