/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.RoomAndStaffAllocationGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.roomAndStaffAllocationGrid',
    store: 'examinationcenters.assessmentEvent.RoomAndStaffAllocationGridStore',
    border: true,
    frame: false,
    title: getExaminationTranslation('ROOM_AND_STAFF_ALLOCATION'),
    selType: 'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
        multiSelect: true,
        mode: 'SIMPLE',
        checkOnly: false
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.assessmentEvent.RoomAndStaffAllocationGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    isGridConfigurable: true,
    enableColumnHide: false, 
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'deleteBtnId',
        text: getExaminationTranslation('DELETE'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'mapStudentBtnId',
        text: getCommonTranslation('MAP_STUDENT'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'publishBtnId',
        text: getExaminationTranslation('PUBLISH_TIMETABLE'),
        disabled: true
    }],
    columns: [{
        header: getCommonTranslation('COURSE_CODE_NAME'),
        dataIndex: 'courseName',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('DETAILED_SEQUENCE'),
        dataIndex: 'eventName',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('DATE'),
        dataIndex: 'printDate',
        flex: .1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getCommonTranslation('TIME'),
        dataIndex: 'time',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('COURSE_ENROLLMENT_COUNT'),
        dataIndex: 'courseEnrolmentCount',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('EVENT_MAPPED_STUDENT'),
        dataIndex: 'eventMappedStudent',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('BUILDING'),
        dataIndex: 'buildingName',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('ROOM'),
        dataIndex: 'resourceNameRoom',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('ROOM_CAPACITY'),
        dataIndex: 'roomCapacity',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('STUDENT_ALLOCATION'),
        dataIndex: 'studntRoomAllocation',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('PRIMARY_INVIGILATOR'),
        dataIndex: 'firstInvigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
        	if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('firstInvigilatorLastName');
        }
    }, {
        header: getCommonTranslation('SECONDARY_INVIGILATOR'),
        dataIndex: 'secondInivigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
        	if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('secondInivigilatorLastName');
        }
    }, {
        header: getCommonTranslation('INVIGILATOR_3'),
        dataIndex: 'thirdInivigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
        	if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('thirdInivigilatorLastName');
        }
    }, {
        header: getCommonTranslation('INVIGILATOR_4'),
        dataIndex: 'fourthInivigilatorFirstName',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
        	if(value == null) {
				return "";
			}
        	return value + ' ' + record.get('fourthInivigilatorLastName');
        }
    }, {
        header: getCommonTranslation('MAPPED_STUDENT'),
        dataIndex: 'mappedCount',
        flex: .1,
        sortable: true
    }, {
        header: getCommonTranslation('PUBLISH_STATUS'),
        dataIndex: 'publishStatus',
        flex: .1,
        sortable: true,
        renderer: function (value, metaData, record) {
        	if(value) {
        		return getExaminationTranslation('PUBLISHED');
        	}
        	else {
        		return getExaminationTranslation('NOT_PUBLISHED');
        	}
        }
    }]
});
