/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.assessmentGroupMarksheet.AssessmentGroupMarksheetFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.assessmentgroupmarksheetfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    standardSubmit : false,
    modal: true,
    items: [{
	        xtype: 'fieldcontainer',
	    	layout: 'hbox',
	    	defaults: {
	    		width: 256,
	    		labelAlign: 'top'
	    	},
	        	items: [{
	    			xtype: 'customcombobox',
	    			name:'evaluationGroupId',
	    			itemId:'evaluationGroupItemId',
	    			store:'examinationcenters.manageEvaluation.evaluationgroup.AssessmentGroupMarksheetStore',
	    			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
	    			valueField: 'id',
	    			displayField: 'code',
	    			queryParam:'evaluationGroupCode',
	    			minChars:2,
	    			typeAhead:false,
	    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	    			enableKeyEvents  : 'true',
	    			hideTrigger:false,
	    			forceSelection:true,
	    			allowBlank:false,
	    			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{code}' +
	    					'</div>';
	    				}
	    			}
	    		},{
	    			xtype: 'customcombobox',
	    			name:'program',
	    			itemId:'programItemId',
	    			store:'examinationcenters.manageEvaluation.evaluationgroup.EGMarksheetProgramStore',
	    			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
	    			valueField: 'id',
	    			displayField: 'valueCode',
	    			queryParam:'name',
	    			minChars:3,
	    			//width: 536,
	    			typeAhead:false,
	    			allowBlank:false,
	    			disabled : true,
	    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	    			enableKeyEvents  : 'true',
	    			hideTrigger:false,
	    			forceSelection:true,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{value}' +
	    					'</div>';
	    				}
	    			}
	    		},{
	    			xtype: 'customcombobox',
	    			name: 'batch',
	    			itemId:'batchItemId',
	    			store:'examinationcenters.manageEvaluation.evaluationgroup.EGMarksheetBatchStore',
	    			valueField:'id',
	    			displayField: 'value',
	    			queryParam:'name',
	    			minChars:3,
	    			typeAhead:false,
	    			//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	    			enableKeyEvents  : 'true',
	    			hideTrigger:false,
	    			allowBlank:false,
	    			disabled : true,
	    			forceSelection:true,
	    			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			fieldLabel:getExaminationTranslation('BATCH')
	    		}]
	   },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 256,
        		labelAlign: 'top'
        	},
            	items: [{
    				xtype: 'fieldcontainer',        
    				//width: 236,
    				itemId:'considerProgramTransferField',
    				items:[{
    					xtype: 'radiogroup',
    					//style:{marginLeft:'-2px !important'},
    					itemId:'isConsiderProgramTransfer',
    					name:'isConsiderProgramTransfer',
    					labelAlign: 'top',
    					fieldLabel:getExaminationTranslation('CONSIDER_PROGRAM_TRANSFER'),
    					//columns: 2,
    					vertical: true,
    					items: [
    					        { boxLabel: getAdmissionTranslation('YES'), name: 'isConsiderProgramTransfer', inputValue: true,checked:true},
    					        { boxLabel: getAdmissionTranslation('NO'), name: 'isConsiderProgramTransfer', inputValue: false,}
    					        ]
    				},]
    			},]
        },{
			xtype: 'fieldcontainer',
			width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
	 }]
});
