/**
 * @author kuldeep yadav
 */
Ext.define('Academia.view.examinationcenters.attestationform.GenerateAttestationFormWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.generateattestationformwin',
	title:getCommonTranslation('SELECT_ATTESTATION_FORM_TEMPLATE'),
	modal: true,
	autoScroll:true,
	maxHeight:500,
	width: 600,
	height:300,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
        		//width: 256
			},
			defaults: {
				width: 300
			},
			items: [{
            	xtype: 'customcombobox',
            	itemId:'chooseHallticketTemplate',
        		name: 'chooseHallticketTemplateId',
        	    store:'setup.templatemapping.TemplateNameListFacultyByCode',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('TEMPLATE')
            },{
    	        xtype: 'fieldcontainer',
            	layout: 'hbox',
            	items:[{
            		xtype: 'button',
        			text:'Preview Template',
        			itemId: 'previewTemplateBtn',
        			buttonAlign: 'bottom',
        			ui: 'CustomBtnThird',
        			scale: CONSTANTS.BUTTONSIZE,
        			disabled:true,
        			//hidden:true
        			formBind:true
            	}]
    		}]
		},{
			xtype: 'fieldcontainer',    
			width : '100%',
			cls : 'windowBtnPos',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
                }
            }]
		}]
	}]
});