/**
 /author  Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.averagereport.StudentAverageReportForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentaveragereportform',  
	plugins : "formlabelrequired",
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items : [{
		xtype: 'customcombobox',
		name: 'academyTerm',
		itemId: 'academyTermItemId',
		allowBlank : false,
		fieldLabel : getProgramandcourseTranslation('ACADEMY_TERM'),
		displayField:'value',
		valueField:'id',
		maxLength:15000,
		autoloadStore: false

	},{
		xtype: 'customcombobox',
		name: 'assessmentschemelevel',
		itemId: 'assessmentschemelevelItemId',
		allowBlank : false,
		fieldLabel : getProgramandcourseTranslation('ASSESSEMENT_SCHEME_LEVEL'),
		displayField:'value',
		valueField:'id',
		autoloadStore: false,

	},{

		xtype: 'customcombobox',
		name: 'assessmentlevelname',
		itemId: 'assessmentlevelnameItemId',
		allowBlank : false,
		fieldLabel : getProgramandcourseTranslation('ASSESSEMENT_LEVEL_NAME'),
		displayField:'value',
		valueField:'id',
		autoloadStore: false
	
	}]
   },{
		xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items:[{

    		xtype: 'customcombobox',
    		name: 'programgroup',
    		itemId: 'programGroupItemId',
    		fieldLabel : getProgramandcourseTranslation('PROGRAM_GROUP'),
    		displayField:'value',
    		valueField:'id',
    		maxLength:15000,
    		autoloadStore: false
		
    	  },{

    		xtype: 'multiselectcombofield',
    		width: 536,
//    		height:58,
    		name: 'multiselectAcademyLocation',
    		itemId: 'multiselectAcademyLocationId',
    		allowBlank : true,
    		fieldLabel : getProgramandcourseTranslation('PROGRAM-BATCH'),
    		//store:'common.AcademyLocationNameSeparated',
    		displayField:'value',
    		valueField:'id',
    		 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	}]
   },{
    	xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items : [{
			xtype: 'customcombobox',
			name:'admissionId',
			itemId:'admissionStudentId',
			//store:'reports.programcourse.creditbasedreport.AdmissionStudentByAcademyLocation',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			width: 536,
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'term',
			minChars:3,
			typeAhead:false,
            hideTrigger:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'  +
	                    '</div>';
	                }
	            }
		},{

			xtype: 'customcombobox',
			name:'status',
			itemId:'statusItemId',
			//store:'reports.programcourse.creditbasedreport.AdmissionStudentByAcademyLocation',
			fieldLabel:getExaminationTranslation('STATUS'),			
			valueField: 'id',
			displayField: 'valueCode',
			autoloadStore: false
          
		
		}]},{
            xtype: 'fieldcontainer',
            width: 'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                formBind:true,
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});