/**
 * @author Rohit Sharma
 */
var assessmentLevelListGridStore = Ext.create('Academia.store.examinationcenters.calculateAverage.calculateAverageLevelWise.AssessmentLevelListGridStore');
Ext.define('Academia.view.examinationcenters.calculateAverage.AssessmentLevelListGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.assessmentLevelListGrid',
    store: assessmentLevelListGridStore,
    border: true,
    frame: false,
    //title: getExaminationTranslation('LIST_OF_STUDENTS'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: assessmentLevelListGridStore,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    tbar:[],
    columns: [{
        header: getCommonTranslation('LEVEL_NAME'),
        dataIndex: 'assessmentLevelName',
        flex: 1,
        sortable: true,
        renderer: function(val) {
        	return getCommonTranslation(val);
        }
    }, {
        header: getCommonTranslation('AVERAGE'),
        dataIndex: 'average',
        flex: 1,
        sortable: true,
        renderer: function(val) {
        	try {
        		if(!isNullOrEmpty(val)) {
            		return Math.round(parseFloat(val) * 10) / 10;
            	}
        	}
        	catch(e) {
        		return val;
        	}
        }
    }]
});