Ext.define('Academia.view.examinationcenters.calculateAverage.CalculateAverageYearlyFilter', {
	extend : 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.calculateaverageyearlyfilter',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		layout : 'hbox',
		width: '100%'
	},
	items:[{
		xtype:'fieldcontainer',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:'examinationcenters.calculateAverage.calculateAverageYearly.ProgramStore',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR')
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'examinationcenters.calculateAverage.calculateAverageYearly.BatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			allowBlank:false,
			typeAhead:false,
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:'examinationcenters.calculateAverage.calculateAverageYearly.PeriodStore',
			fieldLabel:getCommonTranslation('PERIOD_YEAR'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			allowBlank:false,
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	},{	
		xtype:'fieldcontainer',
		defaults: {
			labelAlign:'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'admissionCodeSTDName',
			itemId:'admissionCodeSTDName',
			store:'examinationcenters.calculateAverage.calculateAverageYearly.StudentStore',
			valueField: 'id',
			displayField: 'codeValueOtherLang',
			width: 536,
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:false,
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			hideTrigger:false,
			queryParam:'name',
			disabled: true,
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
