/**
 * @author sumit meena
 */
Ext.define('Academia.view.examinationcenters.dashboard.ExamDashboardGraphFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.examdashboardgraphfilter',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
    modal: true,
    plugins:"formlabelrequired",
    isMinWidthNotRequired: true,
    standardSubmit: false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
	            	xtype: 'customcombobox',
	                name: 'showStaticsFor',
	                itemId:'showStaticsForId',
	                store:'examinationcenters.dashboard.ShowStaticsFor',
	                displayField:'value',
	                valueField:'id',
	                forceSelection:true,
		            typeAhead:true,
		            fieldLabel:getExaminationTranslation('SHOW_STATICS'),
					allowBlank:false
	            },{
					xtype: 'customcombobox',
					name: 'reportFor',
					itemId:'reportForItemId',
					store:'examinationcenters.dashboard.ReportType',
					fieldLabel:getExaminationTranslation('REPORT_FOR'),
					displayField:'value',
					valueField:'id',
					typeAhead:true,
					forceSelection:true,
					allowBlank:false
				},{
					xtype: 'customcombobox',
					name: 'evaluationPlanType',
					itemId:'evaluationPlanTypeItemId',
					store:'examCenter.AssignSequence.EvaluationType',
					fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
					displayField:'value',
					valueField:'id',
					typeAhead:true,
					forceSelection:true
				}]
        	},{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
		        	xtype : 'customcombobox',
		        	name : 'evaluationStage',
		        	itemId:'evaluationStageItemId',
		        	fieldLabel : getExaminationTranslation('EVALUATION_STAGE'),
		        	store : 'examinationcenters.CenterUseFor',
		        	valueField : 'id',
		        	displayField : 'value'
	           },{
		        	xtype : 'customcombobox',
		        	name : 'placementEvaluationStage',
		        	itemId:'placementEvaluationStageItemId',
		        	fieldLabel : getExaminationTranslation('EVALUATION_STAGE'),
		        	store : 'examinationcenters.evaluation.PlacementAcademyOthers',
		        	valueField : 'id',
		        	displayField : 'value',
		        	hidden:true
	           },{
		        	xtype: 'customcombobox',
		   			name:'evaluationPlanId',
		   			itemId:'evaluationPlanItemId',
		   			store:'examinationcenters.dashboard.EvaluationPlanByAcademyAndEvalType',
		   			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
		   			valueField: 'id',
		   			displayField: 'value',
		   			queryParam:'evaluationPlanNumber',
		   			minChars:3,
		   			typeAhead:false,
		   			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		   			enableKeyEvents  : 'true',
		   			hideTrigger:false,
		   			forceSelection:true,
		   			disabled:true,
		   			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		   			listConfig: {
		   				listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		   				loadingText: getCommonTranslation('SEARCHING'),
		   				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		   				getInnerTpl: function() {
		   					return '<div class="search-item">' +
		   					'{value}' +
		   					'</div>';
		   				}
		   			}
	           	},{
		        	xtype : 'customcombobox',
		        	name : 'detailSequenceId',
		        	itemId:'detailSequenceItemId',
		        	fieldLabel : getExaminationTranslation('DETAILED_SQUENCE'),
		        	store : 'examinationcenters.manageEvaluation.DetailSequence',
		        	valueField : 'id',
		        	displayField : 'value',
		        	typeAhead:true,
					forceSelection:true,
					disabled:true,
	           }]
           },{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'hbox',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
    		        	xtype : 'customcombobox',
    		        	name : 'evaluationGroupId',
    		        	fieldLabel : getExaminationTranslation('EVALUATION_GROUP'),
    		        	store : 'examinationcenters.dashboard.ExamDashBoardEvaluationEvent',
    		        	valueField : 'id',
    		        	displayField : 'code',
    		        	typeAhead:true,
    					forceSelection:true,
    					disabled:true,
    				    
    	           },{
					    xtype: 'customcombobox',
		     			name:'courseId',
		     			itemId:'courseItemId',
		     			store : 'examinationcenters.dashboard.CourseByEvalPlanID',
		     			fieldLabel: getCommonTranslation('COURSE'),
		     			valueField: 'id',
		     			displayField: 'value',
		     			queryParam:'name',
		     			minChars:3,
		     			typeAhead:false,
		     			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		     			enableKeyEvents  : 'true',
		     			hideTrigger:false,
		     			forceSelection:true,
		     			hidden:true,
		     			width: 536,
		     			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		     			listConfig: {
		     				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		     				loadingText: getCommonTranslation('SEARCHING'),
		     				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		     				getInnerTpl: function() {
		     					return '<div class="search-item">' +
		     					'{value}' +
		     					'</div>';
		     				}
		     			}
	               }]
               	},{
            	   /**
            	    * Add multiple program , batch  and period fields
            	    */
           		xtype:'container',
        		itemId: 'multipleFieldPanel',
        		width: '100%',
        		items:[{
        			xtype: 'fieldcontainer',
        			width: '100%',
        			defaults: {
        	    		labelAlign: 'top',
        	    		width: 256
        	    	},
        			layout: {
        				type: 'hbox',
        				align: 'bottom',
        				width: 256
        			},
        			items: [{
        				
        				xtype: 'customcombobox',
        	 			name:'programId',
        	 			itemId:'programItemId',
        	 			store:'facilitiesresources.resourcebooking.ProgramByAcademyLocationIdsListStore',
        	 			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
        	 			displayField:'valueCode',
        			    valueField:'id',
        	 			queryParam:'programName',
        	 			minChars:3,
        	 			typeAhead:false,
        	 			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	 			enableKeyEvents  : 'true',
        	 			hideTrigger:false,
        	 			forceSelection:true,
        	 			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	 			listConfig: {
        	 				listeners: {
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        	 				loadingText: getCommonTranslation('SEARCHING'),
        	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	 				getInnerTpl: function() {
        	 					return '<div class="search-item">' +
        	 					'{value}' +
        	 					'</div>';
        	 				}
        	 			}  
        			},{
        				xtype: 'customcombobox',
        				name: 'batchId',
        				itemId: 'batchItemId',
        				width: 256,
        				fieldLabel: getExaminationTranslation('BATCH'),
        				store: 'common.BatchesByProgramId',
        				valueField: 'id',
        				displayField: 'value',
        				typeAhead:true,
        				forceSelection:true,
        				disabled:true
        			},{
        				xtype:'customcombobox',
        				name:'periodId',
        				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
        				itemId:'periodItemId',
        				width: 256,
        				fieldLabel:getExaminationTranslation('PERIOD'),
        				valueField: 'id',
        				displayField: 'value',
        				typeAhead:true,
        				forceSelection:true,
        				disabled:true
        			},{
        				xtype: 'button',
        				width: 24,
        				itemId: 'btnAddMultipleFields',
        				cls: 'CustomBodyBtnSettings',
    					tooltip: getCommonTranslation('ADD'),
        				text: getCommonTranslation('ADDBUTTONTEXT'),
        				/*  V2D-98059 disable for bug and
        					move for enhancement 
        					because functionality not develop properly.
        				*/
        				disabled:true
        			}] 
        		}]
        		},{
		            xtype: 'fieldcontainer',
		            width: 'auto',
		            layout: 'hbox',
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SEARCH'),
		                itemId: 'searchBtn',
		                //buttonAlign: 'left',
		                ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind:true,
		                margin: '0 44 0 0 0'
		            },{
		            	xtype: 'button',
		    			itemId: 'resetBtn',
		    			text: getCommonTranslation('RESET'),
		    			ui:'CustomBtnCancel',
		    			scale: CONSTANTS.BUTTONSIZE
		            }]
            }]
});
