/**

 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.evalresultlisting.CourseWiseGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.coursewisegrid',
    store: 'examinationcenters.evalresultlisting.CourseWiseGridStore',
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,
    refreshStoreData: true,
    deferEmptyText: false,
    //cls: 'grid-bottom-border exam-result-course-wise-grid',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        itemId: 'dockedItemsItemId',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.evalresultlisting.CourseWiseGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
    	xtype: 'button',
    	itemId: 'approveButtonItemId',
    	text: getCommonTranslation('APPROVE'),
    	tooltip :getCommonTranslation('APPROVE')
    }],
    columns: [{
        header: getCommonTranslation('PROGRAM_ID'),
        dataIndex: 'programId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('BATCH_ID'),
        dataIndex: 'batchId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('EVALUATION_PLAN_ID'),
        dataIndex: 'evaluationPlanId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('BATCH_NAME'),
        dataIndex: 'batchName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariant',
        flex: 1
    }, {
        header: getCommonTranslation('EVALUATION_PLAN_NUMBER'),
        dataIndex: 'evaluationPlanNumber',
        flex: 1
    }, {
        header: getCommonTranslation('ADMISSION_NO'),
        dataIndex: 'admissionCode',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: 1
    }, {
        header: getCommonTranslation('FIRST_NAME'),
        dataIndex: 'firstName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('MIDDLE_NAME'),
        dataIndex: 'middleName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('LAST_NAME'),
        dataIndex: 'lastName',
        flex: 1
    }, {
        header: getCommonTranslation('MAX_MARKS'),
        dataIndex: 'maxMarks',
        flex: 1
    }, {
        header: getCommonTranslation('MAX_GRADE'),
        dataIndex: 'maxGrade',
        flex: 1
    }, {
        header: getCommonTranslation('OBTAINED_MARKS'),
        dataIndex: 'obtainedMarks',
        flex: 1
    }, {
        header: getCommonTranslation('OFFERED_CREDIT'),
        dataIndex: 'offeredCredit',
        flex: 1
    }, 
    {
        header: getCommonTranslation('OFFERED_ECTS_CREDIT'),
        dataIndex: 'offeredEcts',
        flex: 1,
    },
    {
        header: getCommonTranslation('EFFECTIVE_MARKS'),
        dataIndex: 'effectiveMarks',
        flex: 1
    },
    {
        header: getCommonTranslation('ACHIEVED_ECTS_CREDIT'),
        dataIndex: 'achievedEctsCredit',
        flex: 1,
    },
    {
        header: getCommonTranslation('OBTAINED_CREDIT'),
        dataIndex: 'obtainedCredit',
        flex: 1
    }, {
        header: getCommonTranslation('GRADE_OBTAINED'),
        dataIndex: 'gradeObtained',
        flex: 1
    }, {
        header: getCommonTranslation('GRADE_POINT'),
        dataIndex: 'gradePoint',
        flex: 1
    }, {
        header: getCommonTranslation('SECTION_WISE_COURSE_RANK'),
        dataIndex: 'sectionWiseCourseRank',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_RANK'),
        dataIndex: 'courseRank',
        flex: 1
    }, {
        header: getCommonTranslation('STATUS'),
        dataIndex: 'status',
        flex: 1
    }, {
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('COURSE_VARIANT_ID'),
        dataIndex: 'courseVariantId',
        flex: 1,
        hidden: true
    }, {
    	header: getCommonTranslation('SECTION_NAME'),
    	dataIndex: 'sectionName',
    	flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('SECTION_ID'),
        dataIndex: 'sectionId',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('ID'),
        dataIndex: 'id',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('REVISED_GRADE_OBTAINED'),
        dataIndex: 'revisedGradeObtained',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('USER_STATUS'),
        dataIndex: 'userStatus',
        flex: 1,
        hidden: true
    }]
});