/**
 * @author Manas Luktuke
 */
Ext.define('Academia.view.examinationcenters.evaluationgrouplisting.EvalGroupListingQuickFilterStudentPortal', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.evalgrouplistingquickfilterstudentportal',  
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    modal: true,
    method: 'POST',
    standardSubmit : false,
    plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        		xtype: 'customcombobox',
				name:'program',
				itemId:'programItemId',
				store:'examinationcenters.manageEvaluation.evaluationgroup.EGProgramStore',
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width: 536,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:true,
				disabled:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;  
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
            },{
	        	xtype: 'customcombobox',
	            name: 'batchId',
	            itemId:'batchIdItemId',
	            store:'examinationcenters.manageEvaluation.evaluationgroup.EGBatchStore',
	            displayField:'value', 
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3, 
	            disabled : true,
	            fieldLabel:getExaminationTranslation('BATCH'),
	            allowBlank:true
            },{
            	xtype: 'customcombobox',
                name: 'studentProgram',
                itemId: 'studentProgramId',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                store:'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
                hidden:true,
                valueField: 'programId',
                displayField: 'programCodeValue',                
                typeAhead:true,
            	forceSelection:true,
				width: 536,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					}
           },{
        	   xtype: 'customcombobox',
        	   name: 'studentBatch',
        	   itemId: 'studentBatchId',
        	   displayField: 'batchName',
        	   store:'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
        	   valueField: 'batchId',
        	   queryMode: 'local',
        	   hidden:true,
        	   editable: false,
        	   fieldLabel: getExaminationTranslation('BATCH'),
			   forceSelection:true,
               disabled : true,  
            }]
    },{  
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :'examinationcenters.manageEvaluation.evaluationgroup.AcademicTermbyProgramStore',  
			valueField : 'id',  
			displayField : 'value',
			forceSelection:true,
			queryParam:'qry',  
			typeAhead:false,
		 },{
	        	xtype: 'customcombobox',
	            name: 'evaluationGroupId',
	            itemId: 'evaluationGroupId',
	            store:'examinationcenters.evalresultlisting.EvaluationGroupStudentPortalStore', 
	            displayField:'code',   
	            valueField:'id',
	            fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
				queryParam:'evaluationGroupCode',
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				disabled:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}

	        }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
    			xtype: 'customcombobox',
    			name: 'periodId',
    			itemId: 'periodId',
    			store:'examinationcenters.manageEvaluation.evaluationgroup.AEGPeriodStore',
    			fieldLabel:getExaminationTranslation('PERIOD'),
    			valueField: 'id',
    			displayField: 'value',
    			width: 256,
    			typeAhead:false,
    			disabled:true,
				forceSelection:true,
				hidden:true
    		},{
            	xtype: 'customcombobox',
                name: 'appStatus',
				itemId: 'appStatus',
                store:'examinationcenters.evaluationgrouplisting.EvalGroupApplicationStatusForFilter',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
	            typeAhead:true,
	            fieldLabel:getExaminationTranslation('APPLICATION_STATUS'),
				disabled:true,
            },{
            	/**
            	 * hidden for student portal as discussed with B A (Mrinal)
            	 */
	        	xtype: 'customcombobox',
	            name: 'groupStatus',//Didn't find any parameter in json format 
	            itemId:'evaluationGroupStatus',
	            store: 'examinationcenters.evaluationgroup.EvaluationStatus',
	            displayField: 'value',
	            valueField: 'id',
	            typeAhead: true,
	            fieldLabel:getExaminationTranslation('EVALUATION_GROUP_STATUS'),
	            hidden:true,
				disabled:true, 
				forceSelection:true
            }]
    },{
	    xtype: 'fieldcontainer',
        width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [ {
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        },{
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]
});