/**
 * @author
 * Manas Luktuke
 * @description
 * Clean & optimized Filter panel for "Register For Group"
 * Uses shared getListConfig() helper for all comboboxes.
 */
Ext.define('Academia.view.examinationcenters.evaluationgrouplisting.ResgisterForGroupFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.resgisterforgroupfilter',
    cls: 'customSearchPanel',
    autoScroll: false,
    frame: false,
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",

    /**
     * 🔹 Common reusable listConfig for all combos
     */
    getListConfig: function (displayFieldName) {
        return {
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            getInnerTpl: function () {
                return '<div class="search-item">{' + displayFieldName + '}</div>';
            },
            listeners: {
                beforeshow: function (picker) {
                    var width = picker.up('combobox').getSize().width;
                    picker.minWidth = width;
                    picker.maxWidth = width;
                }
            }
        };
    },

    /**
     * 🔹 Form Items
     */
    items: [
        // Row 1: Program + Batch
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top',
                margin: '0 10 0 0',
                allowBlank: false
            },
            items: [{
                xtype: 'customcombobox',
                name: 'programId',
                itemId: 'programItemId',
                store: 'RegEGStores.RegEGProgramStore',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                displayField: 'programName',
                valueField: 'programId',
                queryParam: 'name',
                width: 460,
                minChars: 2,
                typeAhead: false,
                forceSelection: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: null // will be assigned later in initComponent
            }, {
                xtype: 'customcombobox',
                name: 'batchId',
                itemId: 'batchIdItemId',
                store: 'RegEGStores.RegEGBatchStore',
                fieldLabel: getExaminationTranslation('BATCH'),
                displayField: 'batchName',
                valueField: 'batchId',
                forceSelection: true,
                disabled: true,
                listConfig: null
            }]
        },

        // Row 2: Period + Course
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top',
                margin: '0 10 0 0',
                allowBlank: false
            },
            items: [{
                xtype: 'customcombobox',
                name: 'periodId',
                itemId: 'periodId',
                store: 'RegEGStores.RegEGPeriodStore',
                fieldLabel: getExaminationTranslation('PERIOD'),
                displayField: 'periodName',
                valueField: 'periodId',
				forceSelection:true,
                disabled: true,
                listConfig: null
            },
			{
				    xtype: 'customcombobox',
					name: 'courseId',
					itemId: 'courseId',
				    store: 'RegEGStores.RegEGCourseStore',
				    fieldLabel: getExaminationTranslation('COURSE_NAME'),
				    valueField: 'courseId',
				    displayField: 'courseCode',
				    queryParam: 'name',
					allowBlank: true,
					forceSelection:true,
				    minChars: 2,
				    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				    listConfig: null,

				  /*  listeners: {
				        select: function (combo, recs) {
				            if (!recs.length) return;

				            var f = combo.up('form'),
				                p = f.down('#programItemId'),  // program combo
								b = f.down('#batchIdItemId'),
								prd = f.down('#periodId'),
				                s = f.down('#studentItemId'),  // student combo
				                sid = s ? s.getValue() : null, // current student ID
				                cid = recs[0].raw.courseId;          // selected course ID

				           // if (!p || !sid) return;

				            // reset and reload program combo store based on student & course
				            p.reset(); 
							b.reset();
							prd.reset();

				            var programStore = p.getStore();
				            programStore.removeAll();

				            programStore.getProxy().extraParams = {
				                studentId: sid,
				                courseId: cid
				            };

				            programStore.reload({
				                callback: function (records, operation, success) {
				                    if (success && records && records.length > 0) {
				                        var firstRec = records[0];
				                        var id = firstRec.get('id'); 

				                        p.setValue(id);

				                        // ✅ Fire program select manually (like student combo does)
				                        p.fireEvent('select', p, [firstRec], { isCourseTriggered: true });
				                    }
				                }
				            });
				        }
				    }*/
				}]
        },

        // Row 3: Buttons
        {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            layout: 'hbox',
            items: [{
                xtype: 'button',
                itemId: 'searchBtn',
                text: getCommonTranslation('SEARCH'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'resetBtn',
                text: getCommonTranslation('RESET'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }
    ],

    /**
     * 🔹 Hooks to controller logic
     */
    listeners: {
        afterrender: function (form) {
            var ctrl = Academia.getApplication()
                .getController('AssessmentGroupRegistration.AssessmentGroupRegistrationController');
            if (ctrl && typeof ctrl.resetAndReloadFilter === 'function') {
                ctrl.resetAndReloadFilter(form);
            }
        }
    },

    /**
     * 🔹 Attach dynamic listConfig and reset handler
     */
    initComponent: function () {
        var me = this;
        me.callParent(arguments);

        // Dynamically assign listConfig using helper
        var combos = [
            { id: '#programItemId', field: 'programName' },
            { id: '#batchIdItemId', field: 'batchName' },
            { id: '#periodId', field: 'periodName' },
            { id: '#courseId', field: 'courseName' }
        ];
        Ext.each(combos, function (cfg) {
            var combo = me.down(cfg.id);
            if (combo) combo.listConfig = me.getListConfig(cfg.field);
        });

        // Reset button click → call controller function
        var resetBtn = me.down('#resetBtn');
        if (resetBtn) {
            resetBtn.on('click', function () {
                var ctrl = Academia.getApplication()
                    .getController('AssessmentGroupRegistration.AssessmentGroupRegistrationController');
                if (ctrl && typeof ctrl.resetAndReloadFilter === 'function') {
                    ctrl.resetAndReloadFilter(me);
                }
            });
        }
    }
});