/**
 * @Author Pankaj Sisodiya
 */
Ext.define('Academia.view.examinationcenters.evalution.coverageDetails.CoverageDetailsFilterForm',{ 
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coverageDetailsFilterForm',
	autoScroll: false,
	 cls:'customSearchPanel',
	 modal: true,
	 title: getCommonTranslation('SEARCH_FILTERS'),
	    plugins : "formlabelrequired",
	items : [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        margin: '3 0 0 0',
        defaults: {
            width: 256,
            labelAlign: 'top',
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
				store:'examinationcenters.evaluation.coverageDetails.EligibleAcademicTermStore',
			queryParam:'academicTermName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			width: 536,
			name: 'academyLocationId',
			itemId: 'academyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'examinationcenters.evaluation.coverageDetails.EligibleFacultyCampusStore',
			displayField:'value',
			valueField:'id',
			//autoloadStore: false,
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
    },
    {
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'courseItemId',
			itemId: 'courseItemId',
			store:'examinationcenters.evaluation.coverageDetails.EligibleCourseCodeStore',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
		//	queryMode: 'local',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
        	xtype: 'customcombobox',
            name: 'courseVariantItemId',
            itemId:'courseVariantItemId',
            store:'examinationcenters.evaluation.coverageDetails.EligibleCourseVariantsStore',
            displayField:'value',
            valueField:'id',
			minChars:3,
			displayField: 'value',
			queryParam:'name',
			//width: 536,
			width: 536,
			
			typeAhead:false,
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			//editible:false
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
    },{
	xtype : 'fieldcontainer',
	width: 'auto',
	cls: 'customSearchPanelBtnsFieldContainerCls',
	layout: 'hbox',
	items: [{
		xtype: 'button',
		text: getCommonTranslation('SEARCH'),
		itemId: 'searchCoverageBtn',
		buttonAlign: 'left',
		ui: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE,
		formBind : true
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetCoverageBtn',
		ui: 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE   
	}	
    ]}]

});