/**
 * Dharmendra.prajapati
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationDetail.EvaluationPlanHierarchyCopyWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.evaluationplanhierarchycopywin',
	requires: ['Ext.ux.form.ItemSelector'],
    modal: true,
    autoScroll:false,
    title: getExaminationTranslation('COPY_HIERARCHY_FROM'),
    maxHeight:600,
    
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        layout: 'anchor',
        defaults: {
        	  labelAlign: 'top',
        	  width: 256,
            anchor: '100%'
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
	        items: [{  
        	    	xtype: 'hidden',
        	    	name: 'levelType',
        	    	itemId :'levelTypeId'
	            },{  
	        	    xtype: 'hidden',
	                name: 'levelOne',
	                itemId: 'levelOneId'
	            },{  
	        	    xtype: 'hidden',
	                name: 'levelTwo',
	                itemId: 'levelTwoId'
	            },{  
	        	    xtype: 'hidden',
	                name: 'levelThree',
	                itemId: 'levelThreeId'
	            }, {
	            xtype: 'customcombobox',
	            name: 'evaluationTypelevel',
	            itemId:'evaluationTypelevelItemId',
	            fieldLabel: getExaminationTranslation('EVALUATION_TYPE'),
	            store:'examinationcenters.evaluation.EvaluationType',
	            displayField:'value',
	            valueField:'value',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            hidden:true,
	            allowBlank:false,
	            matchFieldWidth:true,
	        },{//Academics
	            xtype: 'customcombobox',
	            name: 'evaluationSubTypeLevel',
	            itemId:'evaluationSubTypeLevelItemId',
	            fieldLabel: getExaminationTranslation('EVALUATION_SUB_TYPE'),
	            store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForAcademic',
	            displayField:'value',
	            valueField:'value',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            allowBlank: false,
	            hidden:true,
	            matchFieldWidth:true,
	        }, {
				xtype: 'customcombobox',
				name: 'sequenceHeaderId',
				itemId:'sequenceHeaderIdItemdId',
				fieldLabel: getExaminationTranslation('EVALUATION_SEQUENCE'),
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSequenceHeader',
				displayField:'code',
				valueField:'id',
				forceSelection:true,
	            typeAhead:true,
	            minChars:3,
				allowBlank: false,
				hidden:true,
	            matchFieldWidth:true,
	            maxLength: 1024,
			},// For other
			{
	            xtype: 'customcombobox',
	            name: 'evaluationOtherTypelevel',
	            itemId:'evaluationOtherTypelevelItemId',
	            fieldLabel: getExaminationTranslation('CATEGORY'),
	            store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationTypeOtherLevelOneForm'),
	            displayField:'value',
	            valueField:'value',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            hidden:true,
	            allowBlank:false,
	            matchFieldWidth:true,
	        },{//Academics
	            xtype: 'customcombobox',
	            name: 'evaluationOtherSubTypeLevel',
	            itemId:'evaluationOtherSubTypeLevelItemId',
	            fieldLabel: getExaminationTranslation('SUB_CATEGORY'),
	            store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForOther',
	            displayField:'value',
	            valueField:'value',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            allowBlank: false,
	            hidden:true,
	            matchFieldWidth:true,
	        }, {
            	xtype: 'fieldcontainer',
                width:'100%',
                cls:'windowBtnPos',
                items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'submitBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});