/*
 * Kamlesh
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanLevelOneForm', {
	extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.evaluationplanleveloneform',
    title: '',
    autoScroll:false,
    frame: true,
    cls: 'x-form-fixed-footer-parent',
    items:[{
    	xtype:'form',
    method: 'POST',
    layout: {
        type: 'vbox'
    },
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    plugins:"formlabelrequired",
    items: [{
           	xtype: 'fieldcontainer',
        	width:'100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults :{
        		width: 256,
        		labelAlign:'top'
        	},
            items: [{
    	        xtype: 'hidden',
    	        name: 'id'
    	    },{
    	        xtype: 'hidden',
    	        name: 'evaluationPlanId'
    	    },{
    	        xtype: 'hidden',
    	        name: 'evalPlanLevelOneStatus'
    	    },{//Academics
    	    	/**
    	    	 * This is a rest call not enum here i have to send type instead of id.
    	    	 */
                xtype: 'customcombobox',
                name: 'evaluationTypeAcademic',
                itemId:'evaluationTypeAcademicItemId',
                fieldLabel: getExaminationTranslation('EVALUATION_TYPE'),
                store:'examinationcenters.evaluation.EvaluationType',
                displayField:'value',
                valueField:'value',
                forceSelection:true,
                typeAhead:true,
                minChars:3,
                hidden:true,
                allowBlank:false,
                matchFieldWidth:true,
            },{//External organization
                xtype: 'customcombobox',
                name: 'evaluationTypeExternal',
                itemId:'evaluationTypeExternalItemId',
                fieldLabel: getExaminationTranslation('EXTERNAL_COURSE'),
                store:'examinationcenters.evaluation.CourseMaster',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                typeAhead:true,
                minChars:3,
                hidden:true,
                allowBlank:true
            },{//Others
                xtype: 'customcombobox',
                name: 'evaluationTypeOther',
                itemId:'evaluationTypeOtherItemId',
                fieldLabel: getExaminationTranslation('CATEGORY'),
                store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationTypeOtherLevelOneForm'),
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                typeAhead:true,
                minChars:3,
                hidden:true,
                allowBlank:false,
                matchFieldWidth:true
            },{
                xtype: 'numberfield',
                name: 'weightage',
                fieldLabel: getExaminationTranslation('WEIGHTAGE'),
                minValue : 0,
                maxValue : 100,
                allowBlank: false
            },]
        },{
           	xtype: 'fieldcontainer',
        	width:'100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults :{
        		width: 256,
        		labelAlign:'top'
        	},
            items: [{
                xtype: 'customcombobox',
                store:'examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData',
                name: 'marksOrGrade',
                itemId:'marksOrGradeItemId',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                typeAhead:true,
                fieldLabel:getExaminationTranslation('GRADEMARKS'),
                allowBlank: false
          },{
              xtype: 'customcombobox',
              name: 'gradeType',
              store:'gradeMaster.GradeTypeNameValueStore',
              itemId:'gradeTypeItemId',
              displayField:'value',
              valueField:'value',
              forceSelection:true,
              typeAhead:true,
              fieldLabel:getExaminationTranslation('GRADE_TYPE'),
              hidden:true,
              allowBlank: true
           }]
       },{
	           	xtype: 'fieldcontainer',
	        	width:'100%',
	        	layout: {
	        		type: 'hbox'
	        	},
	        	defaults :{
	        		width: 256,
	        		labelAlign:'top'
	        	},
	            items: [{
	     		  xtype: 'numberfield',
	              name: 'minMarksOrGradeNumber',
	              fieldLabel:getExaminationTranslation('MINIMUM_PASSING_MARKS'),
	              minValue : 0,
	              allowDecimals:true,
	              decimalPrecision: 2,
	      	      allowBlank: false,
         	      validator : function(val) {
              		 var maxValuefield = this.nextSibling();
              		 var maxValue = maxValuefield.getValue();
              		 if (maxValue != null) {
              			 if (val < maxValue) {
              				 maxValuefield
              				 .clearInvalid();
              				 return true;
              			 } else {
              				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
              			 }
              		 } else {
              			 return true;
              		 }
              	   }
	          },{
	     		  xtype: 'numberfield',
	              name: 'maxMarksOrGradeNumber',
	              fieldLabel:getExaminationTranslation('MAXIMUM_PASSING_MARKS'),
	              minValue : 0,
	      	      allowDecimals:true,
	      	      decimalPrecision: 2,
	      	      allowBlank: false,
         	   	  validator : function(val) {
        	   		 var minValueField =this.previousSibling();
        	   		 var minValue = minValueField
        	   		 .getValue();
        	   		 if (minValue != null) {
        	   			 if (val > minValue) {
        	   				 minValueField
        	   				 .clearInvalid();
        	   				 return true;
        	   			 } else {
        	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
        	   			 }
        	   		 } else {
        	   			 return true;
        	   		 }
        	   	  }
	          },{
	              xtype: 'customcombobox',
	              name: 'minMarksOrGradeCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MINIMUM_PASSING_GRADES'),
	              hidden:true,
	              allowBlank: true
	           },{
	              xtype: 'customcombobox',
	              name: 'maxMarksOrGradeCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MAXIMUM_PASSING_GRADES'),
	              hidden:true,
	              allowBlank: true
	           }]
          },{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				store:'examinationcenters.evaluation.RoundingModeForLevelOne',
				name: 'roundingMode',
				itemId:'roundingModeItemId',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				hidden:false,
				fieldLabel:getExaminationTranslation('ROUNDING_MODE'),
				allowBlank: false
			},{
				xtype: 'numberfield',
				name: 'roundingCount',
				minValue:0,
				maxValue:4,
				fieldLabel: getExaminationTranslation('ROUNDING_POINT')
			}]
		},{
             	xtype: 'fieldcontainer',
            	width:'100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults :{
            		width: 256,
            		labelAlign:'top'
            	},
                items: [{
    	        	xtype      : 'radiogroup',
    	            fieldLabel : getExaminationTranslation('WHETHER_SHOWN_IN_MARKSHEET'),
    	            name:'showInMarksheet',
    	            itemId:'showInMarksheetRadioGroupItemId',
    	            defaults: {
    	                flex: 1
    	            },
    	            layout: 'hbox',
    	            items:[{ 
    	            	boxLabel: getCommonTranslation('YES'), 
    	            	name: 'whetherShowInMarksheet', 
    	            	inputValue: true,
    	            	checked:true
    	            },{ 
    	            	boxLabel: getCommonTranslation('NO'), 
    	            	name: 'whetherShowInMarksheet', 
    	            	inputValue: false
    	            }]
    	       },{
    	       	    xtype  : 'textfield',
    	            name:'printNameInMarksheet',
    	            itemId:'printNameInMarksheetItemId',
    	            fieldLabel : getExaminationTranslation('EVALUATION_PLAN_TO_BE_PRINTED'),
    	            allowBlank:false,
//    	            forceSelection:true,
//    	            typeAhead:true,
    				maxLength:1024
              }]
            	},/*{
             	xtype: 'fieldcontainer',
            	width:'100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults :{
            		width: 256,
            		labelAlign:'top'
            	},
                items: [ {
                        xtype: 'numberfield',
                        name: 'minMarksOrGradeAwardNumber',
                        fieldLabel:getExaminationTranslation('MINIMUM_MARKS_AWARD'),
                        minValue : 0,
                   	    allowDecimals:false,
                   	    validator : function(val) {
                   		 var maxValuefield = this.nextSibling();
                   		 var maxValue = maxValuefield.getValue();
                   		 if (maxValue != null) {
                   			 if (val < maxValue) {
                   				 maxValuefield
                   				 .clearInvalid();
                   				 return true;
                   			 } else {
                   				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
                   			 }
                   		 } else {
                   			 return true;
                   		 }
                   	 }
                }, {
                    xtype: 'numberfield',
                    name: 'maxMarksOrGradeAwardNumber',
                    fieldLabel:getExaminationTranslation('MAXIMUN_MARKS_AWARD'),
                    minValue : 0,
            	   	allowDecimals:false,
            	   	 validator : function(val) {
            	   		 var minValueField =this.previousSibling();
            	   		 var minValue = minValueField
            	   		 .getValue();
            	   		 if (minValue != null) {
            	   			 if (val > minValue) {
            	   				 minValueField
            	   				 .clearInvalid();
            	   				 return true;
            	   			 } else {
            	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
            	   			 }
            	   		 } else {
            	   			 return true;
            	   		 }
            	   	 }
                },{
	              xtype: 'customcombobox',
	              name: 'minMarksOrGradeAwardCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MINIMUM_GRADES_AWARD'),
	              hidden:true
	           },{
	              xtype: 'customcombobox',
	              name: 'maxMarksOrGradeAwardCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MAXIMUM_GRADES_AWARD'),
	              hidden:true
	           }]
            }*/{
             	xtype: 'fieldcontainer',
            	width:'100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults :{
            		width: 256,
            		labelAlign:'top'
            	},
                items: [{
            	xtype      : 'radiogroup',
                fieldLabel : getExaminationTranslation('WHETHER_REMARK'),
                name:'whetherRemarkRadioGroup',
                itemId: 'whetherRemarkRadioGroupItemId',
                defaults: {
                    flex: 1
                },
                layout: 'hbox',
	                items:[{
	                	boxLabel: getCommonTranslation('YES'), 
	                	name: 'whetherRemark', 
	                	inputValue: true
	                },{ 
	                	boxLabel: getCommonTranslation('NO'), 
	                	name: 'whetherRemark', 
	                	inputValue: false,
	                	checked:true
	                }]
    	        },{
	            	xtype      : 'radiogroup',
	                fieldLabel : getExaminationTranslation('REMARK_ONLY_ASSESSMENT'),
	                name:'remarkOnlyRadioGroup',
		      	    hidden:true,
	                defaults: {
	                    flex: 1
	                },
	                layout: 'hbox',
	                items:[{ 
	                	boxLabel: getCommonTranslation('YES'), 
	                	name: 'remarkOnlyAssessment', 
	                	inputValue: true
	                },{
	                	boxLabel: getCommonTranslation('NO'), 
	                	name: 'remarkOnlyAssessment', 
	                	inputValue: false,
	                	checked:true
	                }]
	          }]
           },{
	            xtype: 'fieldcontainer',
	           	width:'100%',
	           	layout: {
	           		type: 'hbox'
	           	},
	           	defaults :{
	           		width: 256,
	           		labelAlign:'top'
	           	},
	            items: [{
	               xtype      : 'radiogroup',
	               fieldLabel : getExaminationTranslation('WHETHER_PASSESS_CRITICAL'),
	               itemId: 'whetherPassesCriticalId',
	               name:'whetherPassesCriticalId',
	               disabled:true,
	               defaults: {
	                   flex: 1
	               },
	               layout: 'hbox',
	               items:[{ 
		               	boxLabel: getCommonTranslation('YES'), 
		               	name: 'whetherPassesCritical', 
		               	inputValue: true
		           },{ 
		        	   boxLabel: getCommonTranslation('NO'), 
		               name: 'whetherPassesCritical', 
		               inputValue: false,
		               checked:true
	               }]
	            },{
		     		  xtype: 'numberfield',
		              name: 'failMarksToBeAwarded',
		              fieldLabel:getExaminationTranslation('FAIL_MARKS_TO_BE_AWARDED'),
		              minValue : 0,
		      	      allowDecimals:false,
//		      	      allowBlank: false,
		      	      hidden:true,
		      	      flex: 1,
		      	      labelSeparator:''
		        },{
		              xtype: 'customcombobox',
		              name: 'failGradeToBeAwarded',
		              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
		              displayField:'gradeName',
		              valueField:'gradeName',
		              forceSelection:true,
		              typeAhead:true,
//		              allowBlank: false,
		              fieldLabel:getExaminationTranslation('FAIL_GRADE_TO_BE_AWARDED'),
		              hidden:true,
		              flex: 1,
		              labelSeparator:''
		      },{
	              xtype: 'customcombobox',
	              name: 'supplementaryDrool',
	              itemId:'supplementaryDroolItemId',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.SuppplementaryDroolStore',
	              displayField:'value',
	              valueField:'id',
	              forceSelection:true,
	              typeAhead:true,
//	              allowBlank: false,
	              fieldLabel:getExaminationTranslation('SUPPLEMENTARY_DROOL'),
	              flex: 1,
	              hidden:true,
	      }]
           },{
	            xtype: 'fieldcontainer',
	           	width:'100%',
	           	layout: {
	           		type: 'hbox'
	           	},
	           	defaults :{
	           		width: 256,
	           		labelAlign:'top'
	           	},
	           	items: [{
	           		xtype: 'customcombobox',
	           		itemId: 'repetitionTypeId',
	           		name: 'repetitionType',
	           		store:'examinationcenters.evaluation.evaluationPlanHeirarchy.RepetitionTypeEnumStore',
	           		fieldLabel : getExaminationTranslation('REPETITION_TYPE'),
	           		displayField:'value',
	           		valueField:'id',
	           		hidden:true,
	           		forceSelection:true,
	           		editable:false,
	           		typeAhead:true,
	           		labelSeparator:''
	           	},{
	           		xtype: 'customcombobox',
	           		name: 'eventTobeRepeated',
	           		itemId: 'eventTobeRepeatedId',
	           		store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationEventsByLevelIdStore',
	           		fieldLabel : getExaminationTranslation('EVENT_TO_BE_REPEAT'),
	           		displayField:'value',
	           		valueField:'levelId',
	           		hidden:true,
	           		labelSeparator:''
	           	}]
           },{
        	   xtype: 'fieldcontainer',
        	   width:'100%',
        	   layout: {
        		   type: 'hbox'
        	   },
        	   defaults :{
        		   width: 256,
        		   labelAlign:'top'
        	   },
        	   items: [{
        		   xtype      : 'radiogroup',
        		   fieldLabel : getExaminationTranslation('CALCULATE_AVERAGE'),
        		   itemId: 'calculateAverageId',
        		   name:'calculateAverage',
        		   defaults: {
        			   flex: 1
        		   },
        		   layout: 'hbox',
        		   items:[{ 
        			   boxLabel: getCommonTranslation('YES'), 
        			   name: 'whetherCalculateAverage', 
        			   inputValue: true
        		   },{ 
        			   boxLabel: getCommonTranslation('NO'), 
        			   name: 'whetherCalculateAverage', 
        			   inputValue: false,
        			   checked:true
        		   }]
        	   },{
					xtype : 'customcombobox',
					name : 'resultPublishMode',
					itemId:'resultPublishMode',
					fieldLabel : getExaminationTranslation('RESULT_PUBLISH_MODE'),
					store : 'examinationcenters.evaluation.evaluationPlanHeirarchy.ExamResultPublishModeEnumStore',
					valueField : 'id',
					displayField : 'value',
					disabled:true,
					width: 256,
					hidden:true
				}]
           },{
        	   xtype: 'fieldcontainer',
        	   width:'100%',
        	   layout: {
        		   type: 'hbox'
        	   },
        	   defaults :{
        		   width: 256,
        		   labelAlign:'top'
        	   },
        	   items: [{
                   xtype: 'numberfield',
                   name: 'obeWeightage',
                   fieldLabel: getExaminationTranslation('OBE_WEIGHTAGE'),
                   minValue : 0,
                   maxValue : 100,
                   allowBlank: true
               },{
                   xtype: 'checkboxfield',
                   name: 'whetherFinalPromotionLevel',
                   boxLabel: getExaminationTranslation('WHETHER_FINAL_PROMOTION_LEVEL'),
                   inputValue : true,
                   itemId:'whetherFinalPromotionLevel',
                   uncheckedValue: false,
                   hidden:true,
                   labelAlign:'right',
                   width: 400,
                   style:{
                	   marginTop:'20px'
                   }
               }]
           },{    
					xtype : 'fieldcontainer',
					width : '100%',
					layout : {
						type : 'hbox'
					},
					defaults : {
						width: 256,
						labelAlign : 'top'
					},
					
					items :[
						
						{
				    xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: 'right',
		            itemId:'WhetherLatestmarksRuleApplicable',
		            boxLabel: getExaminationTranslation('WHETHER_LATEST_MARKS_RULE'),
		            name: 'WhetherLatestmarksRuleApplicable',
		            inputValue : true,
		            uncheckedValue: false, 
                    hidden:true
						}
					]
           }, {
        	   xtype:'fieldcontainer',
        	   cls: 'form-fixed-footer',
        	   width:'auto',
        	   layout: 'hbox',
		        items: [{
		            xtype: 'button',
		            text: getExaminationTranslation('SAVE'),
		            itemId: 'addButtonItemId',
		            ui: 'CustomBtnSubmit',
		            scale: CONSTANTS.BUTTONSIZE,
		            formBind: true
		        }, {
		            xtype: 'button',
		            text: getExaminationTranslation('CANCEL'),
		            itemId: 'resetButtonItemId',
		            ui: 'CustomBtnCancel',
		            scale: CONSTANTS.BUTTONSIZE,
		            handler: function() {
		            	var form = this.up('form').getForm()
		                form.reset();
		                var categroy = form.findField("evaluationTypeOther");
		                categroy.allowBlank=false;

		            }
		        }]
		    }]
    }]
});