/*
 * Kamlesh
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationPlanHierarchy.EvaluationPlanLevelTwoForm', {
	extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.evaluationplanleveltwoform',
    title: '',
    autoScroll:false,
    frame: true,
    cls: 'x-form-fixed-footer-parent',
    items:[{
    	xtype:'form',
    method: 'POST',
    layout: {
        type: 'vbox'
    },
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 256
    },
    plugins:"formlabelrequired",
    items: [{
           	xtype: 'fieldcontainer',
        	width:'100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults :{
        		width: 256,
        		labelAlign:'top'
        	},
            items: [{
    	        xtype: 'hidden',
    	        itemId: 'addEdit'
    	    }, {
    	        xtype: 'hidden',
    	        name: 'id'
    	    },{
    	        xtype: 'hidden',
    	        name: 'evaluationPlanOneId'
    	    },{
    	        xtype: 'hidden',
    	        name: 'evaluationPlan2LevelStatus'
    	    },{//Academics
                xtype: 'customcombobox',
                name: 'courseComponentAcademic',
                itemId:'courseComponentAcademicItemId',
                fieldLabel: getExaminationTranslation('EVALUATION_SUB_TYPE'),
                store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForAcademic',
                displayField:'value',
                valueField:'value',
                forceSelection:true,
                typeAhead:true,
                minChars:3,
                allowBlank: false,
                hidden:true,
                matchFieldWidth:true,
            },{//External Organization
                xtype: 'customcombobox',
                name: 'courseComponentExternal',
                itemId:'courseComponentExternalItemId',
                fieldLabel: getExaminationTranslation('COURSE_ASSESSMENT'),
                store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForExternal',
                displayField:'value',
                valueField:'value',
                forceSelection:true,
                typeAhead:true,
                minChars:3,
                allowBlank: true,
                hidden:true
            },{//Others
                xtype: 'customcombobox',
                name: 'courseComponentOther',
                itemId:'courseComponentOtherItemId',
                fieldLabel: getExaminationTranslation('SUB_CATEGORY'),
                store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormTwoForOther',
                displayField:'value',
                valueField:'id',
                forceSelection:true,
                typeAhead:true,
                minChars:3,
                allowBlank: false,
                hidden:true,
                matchFieldWidth:true
            },{
                xtype: 'numberfield',
                name: 'weightage',
                fieldLabel: getExaminationTranslation('WEIGHTAGE'),
                minValue : 0,
                maxValue : 100,
                allowBlank: false
          }]
        },{
           	xtype: 'fieldcontainer',
        	width:'100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults :{
        		width: 256,
        		labelAlign:'top'
        	},
            items: [{
	            xtype: 'customcombobox',
	            store:'examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData',
	            name: 'marksOrGrade',
	            itemId:'marksOrGradeItemId',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            fieldLabel:getExaminationTranslation('GRADEMARKS'),
	            allowBlank: false
	      },{
            xtype: 'customcombobox',
            name: 'gradeType',
            store:'gradeMaster.GradeTypeNameValueStore',
            itemId:'gradeTypeItemId',
            displayField:'value',
            valueField:'value',
            forceSelection:true,
            typeAhead:true,
            fieldLabel:getExaminationTranslation('GRADE_TYPE'),
            hidden:true,
            allowBlank: false
         }]
        },{
	           	xtype: 'fieldcontainer',
	        	width:'100%',
	        	layout: {
	        		type: 'hbox'
	        	},
	        	defaults :{
	        		width: 256,
	        		labelAlign:'top'
	        	},
	            items: [{
	     		  xtype: 'numberfield',
	              name: 'minMarksOrGradeNumber',
	              fieldLabel:getExaminationTranslation('MINIMUM_PASSING_MARKS'),
	              minValue : 0,
	              allowDecimals:true,
	              decimalPrecision: 2,
	      	      allowBlank: false,
             	  validator : function(val) {
                  		 var maxValuefield = this.nextSibling();
                  		 var maxValue = maxValuefield.getValue();
                  		 if (maxValue != null) {
                  			 if (val < maxValue) {
                  				 maxValuefield
                  				 .clearInvalid();
                  				 return true;
                  			 } else {
                  				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
                  			 }
                  		 } else {
                  			 return true;
                  	}
                 }
	         },{
	     		  xtype: 'numberfield',
	              name: 'maxMarksOrGradeNumber',
	              fieldLabel:getExaminationTranslation('MAXIMUM_PASSING_MARKS'),
	              minValue : 0,
	      	      allowDecimals:true,
	      	      decimalPrecision: 2,
	      	      allowBlank: false,
	      	      validator : function(val) {
       	   		  var minValueField =this.previousSibling();
       	   		  var minValue = minValueField
       	   		  .getValue();
       	   		  if (minValue != null) {
       	   			 if (val > minValue) {
       	   				 minValueField
       	   				 .clearInvalid();
       	   				 return true;
       	   			 } else {
       	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
       	   			 }
       	   		   } else {
       	   			 return true;
       	   		  }
       	   	    }
	         },{
	              xtype: 'customcombobox',
	              name: 'minMarksOrGradeCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MINIMUM_PASSING_GRADES'),
	              hidden:true,
	              allowBlank: false
             },{
	              xtype: 'customcombobox',
	              name: 'maxMarksOrGradeCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MAXIMUM_PASSING_GRADES'),
	              hidden:true,
	              allowBlank: false
	           }]
          },{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				store:'examinationcenters.evaluation.RoundingModeForLevelTwo',
				name: 'roundingMode',
				itemId:'roundingModeItemId',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				hidden:false,
				fieldLabel:getExaminationTranslation('ROUNDING_MODE'),
				allowBlank: false
			},{
				xtype: 'numberfield',
				name: 'roundingCount',
				minValue:0,
				maxValue:4,
				fieldLabel: getExaminationTranslation('ROUNDING_POINT')
			}]
		},{
             	xtype: 'fieldcontainer',
            	width:'100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults :{
            		width: 256,
            		labelAlign:'top'
            	},
                items: [{
    	        	xtype      : 'radiogroup',
    	            fieldLabel : getExaminationTranslation('WHETHER_SHOWN_IN_MARKSHEET'),
    	            name:'showInMarksheet',
    	            itemId:'showInMarksheetRadioGroupItemId',
    	            defaults: {
    	                flex: 1
    	            },
    	            layout: 'hbox',
    	            items:[{ 
    	            	boxLabel: getCommonTranslation('YES'), 
    	            	name: 'whetherShowInMarksheet', 
    	            	inputValue: true,
    	            	checked:true
    	            },{ 
    	            	boxLabel: getCommonTranslation('NO'), 
    	            	name: 'whetherShowInMarksheet', 
    	            	inputValue: false
    	            }]
    	       },{
    	       	    xtype  : 'textfield',
    	            fieldLabel : getExaminationTranslation('COURSE_COMPONENT_TO_BE_PRINTED'),
    	            name:'printNameInMarksheet',
    	            itemId:'printNameInMarksheetItemId',
    	            allowBlank:false,
    				maxLength:1024
              }]
            },{
             	xtype: 'fieldcontainer',
            	width:'100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults :{
            		width: 256,
            		labelAlign:'top'
            	},
                items: [/* {
                        xtype: 'numberfield',
                        name: 'minMarksOrGradeAwardNumber',
                        fieldLabel:getExaminationTranslation('MINIMUM_MARKS_AWARD'),
                        minValue : 0,
                   	    allowDecimals:false,
                   	    validator : function(val) {
                   		 var maxValuefield = this.nextSibling();
                   		 var maxValue = maxValuefield.getValue();
                   		 if (maxValue != null) {
                   			 if (val < maxValue) {
                   				 maxValuefield
                   				 .clearInvalid();
                   				 return true;
                   			 } else {
                   				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
                   			 }
                   		 } else {
                   			 return true;
                   		 }
                   	 }
                }, {
                    xtype: 'numberfield',
                    name: 'maxMarksOrGradeAwardNumber',
                    fieldLabel:getExaminationTranslation('MAXIMUN_MARKS_AWARD'),
                    minValue : 0,
            	   	allowDecimals:false,
            	   	 validator : function(val) {
            	   		 var minValueField =this.previousSibling();
            	   		 var minValue = minValueField
            	   		 .getValue();
            	   		 if (minValue != null) {
            	   			 if (val > minValue) {
            	   				 minValueField
            	   				 .clearInvalid();
            	   				 return true;
            	   			 } else {
            	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
            	   			 }
            	   		 } else {
            	   			 return true;
            	   		 }
            	   	 }
                },{
	              xtype: 'customcombobox',
	              name: 'minMarksOrGradeAwardCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MINIMUM_GRADES_AWARD'),
	              hidden:true
	           },{
	              xtype: 'customcombobox',
	              name: 'maxMarksOrGradeAwardCombo',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
	              displayField:'gradeName',
	              valueField:'gradeName',
	              forceSelection:true,
	              typeAhead:true,
	              fieldLabel:getExaminationTranslation('MAXIMUM_GRADES_AWARD'),
	              hidden:true
	           }*/]
            },{
             	xtype: 'fieldcontainer',
            	width:'100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults :{
            		width: 256,
            		labelAlign:'top'
            	},
                items: [{
            	xtype      : 'radiogroup',
                fieldLabel : getExaminationTranslation('WHETHER_REMARK'),
                name:'whetherRemarkRadioGroup',
                itemId:'whetherRemarkRadioGroupItemId',
                defaults: {
                    flex: 1
                },
                layout: 'hbox',
	                items:[{ 
	                	boxLabel: getCommonTranslation('YES'), 
	                	name: 'whetherRemark', 
	                	inputValue: true
	                },{ 
	                	boxLabel: getCommonTranslation('NO'), 
	                	name: 'whetherRemark', 
	                	inputValue: false,
	                	checked:true
	                }]
	          },{
	            	xtype      : 'radiogroup',
	                fieldLabel : getExaminationTranslation('REMARK_ONLY_ASSESSMENT'),
	                name:'remarkOnlyRadioGroup',
		      	    hidden:true,
	                defaults: {
	                    flex: 1
	                },
	                layout: 'hbox',
	                items:[{ 
	                	boxLabel: getCommonTranslation('YES'), 
	                	name: 'remarkOnlyAssessment', 
	                	inputValue: true
	                },{
	                	boxLabel: getCommonTranslation('NO'), 
	                	name: 'remarkOnlyAssessment', 
	                	inputValue: false,
	                	checked:true
	                }]
	          }]
           },{
             	xtype: 'fieldcontainer',
            	width:'100%',
            	layout: {
            		type: 'hbox'
            	},
            	defaults :{
            		width: 256,
            		labelAlign:'top'
            	},
            	items: [{
	            	xtype      : 'radiogroup',
	                fieldLabel : getExaminationTranslation('CONTRIBUTE_TO_DETENTION'),
	                name:'contributeToDetentionRadioGroup',
	                itemId:'contributeToDetentionRadioGroupItemId',
	                defaults: {
	                    flex: 1
	                },
	                layout: 'hbox',
		                items:[{ 
		                	boxLabel: getCommonTranslation('YES'), 
		                	name: 'contributeToDetention', 
		                	inputValue: true
		                },{ 
		                	boxLabel: getCommonTranslation('NO'), 
		                	name: 'contributeToDetention', 
		                	inputValue: false,
		                	checked:true
		                }]
		          }]
           },{
            	xtype: 'fieldcontainer',
	           	width:'100%',
	           	layout: {
	           		type: 'hbox'
	           	},
	           	defaults :{
	           		width: 256,
	           		labelAlign:'top'
	           	},
	            items: [{
	               xtype      : 'radiogroup',
	               fieldLabel : getExaminationTranslation('WHETHER_PASSESS_CRITICAL'),
	               itemId: 'whetherPassesCriticalId',
	               name:'whetherPassesCriticalId',
	               disabled:true,
	               defaults: {
	                   flex: 1
	               },
	               layout: 'hbox',
	               items:[{ 
		               	boxLabel: getCommonTranslation('YES'), 
		               	name: 'whetherPassesCritical', 
		               	inputValue: true
	               },{ 
		               	boxLabel: getCommonTranslation('NO'), 
		               	name: 'whetherPassesCritical', 
		               	inputValue: false,
		               	checked:true
	               }]
	           },{
		     		  xtype: 'numberfield',
		              name: 'failMarksToBeAwarded',
		              fieldLabel:getExaminationTranslation('FAIL_MARKS_TO_BE_AWARDED'),
		              minValue : 0,
		      	      allowDecimals:false,
//		      	      allowBlank: false,
		      	      hidden:true,
		      	      labelSeparator:''
		        },{
		              xtype: 'customcombobox',
		              name: 'failGradeToBeAwarded',
		              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
		              displayField:'gradeName',
		              valueField:'gradeName',
		              forceSelection:true,
		              typeAhead:true,
//		              allowBlank: false,
		              fieldLabel:getExaminationTranslation('FAIL_GRADE_TO_BE_AWARDED'),
		              hidden:true,
		              labelSeparator:''
		      },{
	              xtype: 'customcombobox',
	              name: 'supplementaryDrool',
	              itemId:'supplementaryDroolItemId',
	              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.SuppplementaryDroolStore',
	              displayField:'value',
	              valueField:'id',
	              forceSelection:true,
	              typeAhead:true,
//	              allowBlank: false,
	              fieldLabel:getExaminationTranslation('SUPPLEMENTARY_DROOL'),
	              hidden:true,
	      }]
           },{
	            xtype: 'fieldcontainer',
	           	width:'100%',
	           	layout: {
	           		type: 'hbox'
	           	},
	           	defaults :{
	           		width: 256,
	           		labelAlign:'top'
	           	},
	            items: [{
		              xtype: 'customcombobox',
		              name: 'repetitionType',
		              itemId: 'repetitionTypeId',
		              store:'examinationcenters.evaluation.evaluationPlanHeirarchy.RepetitionTypeEnumStore',
		              fieldLabel : getExaminationTranslation('REPETITION_TYPE'),
		              displayField:'value',
		              valueField:'id',
		              forceSelection:true,
		              typeAhead:true,
		              hidden:true,
		              labelSeparator:''
		        },{
	           		xtype: 'customcombobox',
	           		name: 'eventTobeRepeated',
	           		itemId: 'eventTobeRepeatedId',
	           		store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationEventsByLevelIdStore',
	           		fieldLabel : getExaminationTranslation('EVENT_TO_BE_REPEAT'),
	           		displayField:'value',
	           		valueField:'levelId',
	           		hidden:true,
	           		labelSeparator:''
	           	}]
           },{
        	   xtype: 'fieldcontainer',
        	   width:'100%',
        	   layout: {
        		   type: 'hbox'
        	   },
        	   defaults :{
        		   width: 256,
        		   labelAlign:'top'
        	   },
        	   items: [{
        		   xtype      : 'radiogroup',
        		   fieldLabel : getExaminationTranslation('CALCULATE_AVERAGE'),
        		   itemId: 'calculateAverageId',
        		   name:'calculateAverage',
        		   defaults: {
        			   flex: 1
        		   },
        		   layout: 'hbox',
        		   items:[{ 
        			   boxLabel: getCommonTranslation('YES'), 
        			   name: 'whetherCalculateAverage', 
        			   inputValue: true
        		   },{ 
        			   boxLabel: getCommonTranslation('NO'), 
        			   name: 'whetherCalculateAverage', 
        			   inputValue: false,
        			   checked:true
        		   }]
        	   },{
        		   xtype      : 'radiogroup',
        		   fieldLabel : getExaminationTranslation('Z_SCORE'),
        		   itemId: 'zscoreId',
        		   name:'zscoreId',
        		   hidden:true,
        		   defaults: {
        			   flex: 1
        		   },
        		   layout: 'hbox',
        		   items:[{ 
        			   boxLabel: getCommonTranslation('YES'), 
        			   name: 'zscore', 
        			   inputValue: true
        		   },{ 
        			   boxLabel: getCommonTranslation('NO'), 
        			   name: 'zscore', 
        			   inputValue: false,
        			   checked:true
        		   }]
        	   }]
           },{
        	   xtype: 'fieldcontainer',
        	   width:'100%',
        	   layout: {
        		   type: 'hbox'
        	   },
        	   defaults :{
        		   width: 256,
        		   labelAlign:'top'
        	   },
        	   items: [{
					xtype : 'customcombobox',
					name : 'resultPublishMode',
					itemId:'resultPublishMode',
					fieldLabel : getExaminationTranslation('RESULT_PUBLISH_MODE'),
					store : 'examinationcenters.evaluation.evaluationPlanHeirarchy.ExamResultPublishModeEnumStore',
					valueField : 'id',
					displayField : 'value',
					disabled:true,
					width: 256,
					hidden:true
        	   },{
                   xtype: 'numberfield',
                   name: 'obeWeightage',
                   fieldLabel: getExaminationTranslation('OBE_WEIGHTAGE'),
                   minValue : 0,
                   maxValue : 100,
                   allowBlank: true
               }]
           },{
        	   xtype: 'fieldcontainer',
        	   width:'100%',
        	   layout: {
        		   type: 'hbox'
        	   },
        	   defaults :{
        		   width: 256,
        		   labelAlign:'top'
        	   },
        	   items: [{
        		   xtype: 'checkboxfield',
        		   name: 'whetherFinalPromotionLevel',
        		   boxLabel: getExaminationTranslation('WHETHER_FINAL_PROMOTION_LEVEL'),
        		   inputValue : true,
        		   uncheckedValue: false,
        		   labelAlign:'right',
        		   width: 400,
        		   itemId:'whetherFinalPromotionLevel',
        		   hidden:true
        	   }]
           },{    
					xtype : 'fieldcontainer',
					width : '100%',
					layout : {
						type : 'hbox'
					},
					defaults : {
						width: 256,
						labelAlign : 'top'
					},
					
					items :[
						
						{
				    xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: 'right',
		            itemId:'WhetherLatestmarksRuleApplicable',
		            boxLabel: getExaminationTranslation('WHETHER_LATEST_MARKS_RULE'),
		            name: 'WhetherLatestmarksRuleApplicable',
		            inputValue : true, 
		            uncheckedValue: false,         
                    hidden:true
						}
					]
				},{
        	   xtype:'fieldcontainer',
        	   cls: 'form-fixed-footer',
        	   width:'auto',
        	   layout: 'hbox',
	        items: [{
	            xtype: 'button',
	            text: getExaminationTranslation('SAVE'),
	            itemId: 'levelTwoAddButtonId',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true
	        }, {
	            xtype: 'button',
	            text: getExaminationTranslation('CANCEL'),
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE,
	            handler: function() {
	            	  var form = this.up('form').getForm(); 
	            	  var roundingMode=form.findField('roundingMode');
	            	  var roundingCount=form.findField('roundingCount');
	            	  var roundingCountVal = roundingCount.getValue();
	            	  var roundingModeVal = roundingMode.getValue();
	                this.up('form').getForm().reset();
	                roundingMode.setValue(roundingModeVal);
	                roundingCount.setValue(roundingCountVal);
	            }
	       
	      
	        }]
	    }]
    }]
});