/**
 * @author Santosh Sahu
 */
Ext.define('Academia.view.examinationcenters.examSpecialGrade.ManageSpecialGradeFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.managespecialgradefilter',
	plugins : "formlabelrequired",
    //autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    //layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype:'fieldcontainer',
    	width:'100%',
    	layout:'hbox',
    	itemId:'criteriaBasedGradeFieldId',
    	defaults:{
    		labelAlign:'top',
    	},
    	//xtype:'panel',
    	//cls: 'panelNoSpace',
    	style:{marginLeft:'-4px !important'},
    	items:[{
    		xtype: 'radiogroup',
    		itemId:'criteriaBasedGradeId',
    		name:'radiogroupId',
    		columns: 2,
    		items: [
    		        { boxLabel: getExaminationTranslation('SPECIAL_GRADE'), name: 'specialGrade', inputValue: true,checked:true},
    		        { boxLabel: getExaminationTranslation('CRITERIA_BASED_GRADE'), name: 'specialGrade', inputValue: false}
    		        ]
    	}]
    },{

		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'revisedGradingType',
			itemId:'revisedGradingTypeId',
			store:'examinationcenters.reports.RevisedGradingTypeStore',
			fieldLabel:getExaminationTranslation('REVISED_GRADING_TYPE'),
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			width: 256,
			hidden:true,
			typeAhead:false,
			allowBlank:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style:{
    		marginTop:'-2px !important',
    	},
		items: [{
    		xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTermId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			//store :Ext.create('Academia.store.common.AcademicTermStore'),
			store :Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			displayField : 'value',
			queryMode:'local',
			minChars:3,
			forceSelection:true,
			typeAhead:true,
			autoloadStore: false,
			

	},{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationReportProgramStore'),
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueSecondValue',
			queryParam:'name',
			minChars:3,
			width:475,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout:'hbox',
		defaults: {
            width: 245,
            labelAlign: 'top'
        },
		items:[
			{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.SpecialGradeBatchStore'),
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			disabled:true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.SpecialGradePeriodStore'),
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			queryParam:'name',
			minChars:3,
			width:240,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		
		}]
	},{
		xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        itemId:'specialGradeFieldItemId',
        hidden:true,
        defaults: {
            width: 245,
            labelAlign: 'top'
        },
		items : [{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationReportCourseStore'),
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
			listeners: {
				blur: function(combo) {
					// Check if the combo box has a valid value
					var store = combo.getStore();
					var value = combo.getValue();
					var record = store.findRecord(combo.valueField, value);

					if (!record) {
						// Clear the field if the entered value doesn't match any record
						combo.reset();
					}
				}
}
		},{
        	xtype: 'customcombobox',
            name: 'courseVariant',
            itemId:'courseVariantItemId',
            store:Ext.create('Academia.store.attendance.VariantMappedToSpecialGrade'),
            displayField:'value',
            valueField:'id',
            width:475,
            maxLength:9999,
  			maxSelections :9999,
            forceSelection:true,
            typeAhead:true,
            editable:false,
            allowBlank:false,
			autoloadStore: false,
            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
            disabled:true,
        	listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
        	}
		}
		]
	},{
		xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        itemId:'criteriaBasedCourseFieldItemId',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
		items : [{
        	xtype: 'customcombobox',
			name:'criteriaBasedCourseId',
			itemId:'criteriaBasedCourseItemId',
			store:Ext.create('Academia.store.examinationcenters.assessmentEvent.CoursesAndCourseGradeTypeForEvents'),
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'courseName',
			minChars:3,
			typeAhead:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
        },{
			xtype: 'customcombobox',
			name:'evaluationplan',
			itemId:'evalautionPlanId',
			store:Ext.create('Academia.store.examinationcenters.assessmentEvent.EvaluationPlanForEventStore'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 256,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
        	xtype: 'multiselectcombofield',
            name: 'criteriaBasedCourseVariant',
            itemId:'criteriaBasedCourseVariantItemId',
            store:Ext.create('Academia.store.attendance.VariantMappedToSpecialGrade'),
            displayField:'value',
            valueField:'id',
            width: 256,
            maxLength:9999,
  			maxSelections :9999,
            forceSelection:true,
            typeAhead:true,
            editable:false,
			autoloadStore: false,
            cls:'commonAutoHeightMultiselectField',
            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
            listConfig: {listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
					picker.width = 'auto';
					setTimeout(function(){
						picker.el.dom.style.width='auto';
						picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
					},10);
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}' +
				'</div>';
			}}
		}]
	},{
		xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        itemId:'admissionFieldId',
        defaults: {
        	width: 536,
            labelAlign: 'top'
        },
		items : [{
			xtype: 'customcombobox',
			name: 'admissionId',
			itemId: 'admissionItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.GradeWiseStudentListStore'),
			fieldLabel:getExaminationTranslation('ADMISSIONID_STUDENTID_STUDENTNAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'studentName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			maxLength: 100,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        itemId:'specialGradeFieldId',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
		items : [{
			xtype: 'customcombobox',
			name: 'STUDENT_ID',
			itemId: 'studentItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationReportStudentStore'),
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width:475,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{valueCode}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'specialGradeCombo',
			itemId: 'specialGradeId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationSpecialGradeComboStore'),
            displayField:'value',
            valueField:'value',
            fieldLabel:getExaminationTranslation('SPECIAL_GRADE'),
			width: 256,
			allowBlank:false,
			//editable: false
			forceSelection:true,
			queryMode: 'local',
			minChars: 3
				
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		hidden:true,
		style:{marginTop: '25px!important',paddingTop:'30px!important'},     
		width:'100%',
		itemId:'moreFilterId', 
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'criteriaBasedProgramId',
				itemId:'criteriaBasedProgramItemId',
				store:Ext.create('Academia.store.examinationcenters.reports.CriteriaBasedProgramStore'),
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueSecondValue',
				queryParam:'name',
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name:'criteriaBasedBatchId',
				itemId:'criteriaBasedBatchItemId',
				store:Ext.create('Academia.store.examinationcenters.reports.SpecialGradeBatchStore'),
				fieldLabel:getExaminationTranslation('BATCH'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 256,
				disabled:true,
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'criteriaBasedPeriodId',
				itemId: 'criteriaBasedPeriodItemId',
				store:Ext.create('Academia.store.examinationcenters.reports.SpecialGradePeriodStore'),
				fieldLabel:getExaminationTranslation('PERIOD'),
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				queryParam:'name',
				minChars:3,
				width: 256,
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
