/**
 * @author bhanu ps
 */
Ext.define('Academia.view.examinationcenters.examlogistic.PlanWiseGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.planwisegrid',
	store: 'examinationcenters.examlogistic.PlanWiseAttendanceGridStore',
	title: getExaminationTranslation('PLAN_WISE_LIST'),
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.examlogistic.PlanWiseAttendanceGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar : [{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveItemId',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
		}]
	},{
		xtype: 'button',
		itemId: 'btnPresentItemId',
		disabled:true,
		tooltip: getExaminationTranslation('MARK_PRESENT'),
		text:getExaminationTranslation('MARK_PRESENT'),
		style:{
				marginRight:'5px'
		}
	},{
		xtype: 'button',
		itemId: 'btnAbsentItemId',
		disabled:true,
		tooltip: getExaminationTranslation('MARK_ABSENT'),
		text:getExaminationTranslation('MARK_ABSENT'),
	},{
		xtype: 'button',
		itemId: 'btnReset',
		tooltip: getExaminationTranslation('RESET'),
		text:getExaminationTranslation('RESET'),
		hidden:true
	}],
	columns: [{
		header:  getExaminationTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex : 1,
		hidden:true
	},{
		header:  getExaminationTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1
	},{
		header:getExaminationTranslation("STUDENT_NAME"),
		dataIndex : 'studentName',
		flex : 1
	},{
		header : getExaminationTranslation('HALL_TICKET'),
		dataIndex : 'hallTicket',
		flex : 1
	},{
		header :getAdmissionTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1
	},{
		header : getExaminationTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1
	},{
		header : getExaminationTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1
	},{
		header : getExaminationTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1
	},{
		header:getExaminationTranslation("COURSE"),
		dataIndex : 'courseName',
		flex : 1
	},{
		header:getExaminationTranslation('DETAILED_SEQUENCE'),
		dataIndex : 'eventName',
		flex : 1,
		 renderer: function (value, meta, record, rowIndex) {
	        	if(!isNullOrEmpty(record.get('newEventName'))){
	        		return record.get('newEventName')
	        	}
	      
	        }
		
	},
	
	{
		header : getExaminationTranslation('MARK_ATTENDANCE'),
		dataIndex : 'presentAbsId',
		flex : 1,
		editor : {
			xtype: 'customcombobox',
			name:'presentAbsId',
			itemId:'presentAbsItemId',
			store:'transport.vehicle.PresentAbsentEnum',
			valueField : 'value',
			forceSelection:true,
            editable:false,
            typeAhead:false,
			displayField : 'value',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				var grid = view;
				var store = grid.getStore();
				var models = grid.getStore().getRange();
			if(isNullOrEmpty(val)){
				
				models[rowIndex].set("presentAbsId","Present");
				models[rowIndex].set("malPracticeStatus",null);
				if(record.data.whetherExamAttended){
					return "Present";
				}
				else {
					models[rowIndex].set("presentAbsId","Absent");
					return "Absent";
				}
			} else {
				if(val == 'Absent') {
						models[rowIndex].set("malPracticeStatus","");
					}
				return val;
			}
		}
	},{
		header : getExaminationTranslation('MALPRACTICE'),
		dataIndex : 'malPracticeStatus',
		flex : 1,
		editor : {
			xtype: 'customcombobox',
			name:'malPracticeId',
			itemId:'malPracticeItemId',
			store:'examinationcenters.examlogistic.ExamLogisticMalPractice',
			valueField : 'value',
			forceSelection:true,
            editable:false,
            typeAhead:false,
			displayField : 'value',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			},
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var grid = view;
			var $this= this;
			var store = grid.getStore();
			var models = grid.getStore().getRange();
			//if(store.data.items[rowIndex].data.presentAbsId!="Absent"){
				if(!isNullOrEmpty(record.data.examMalPracticType) && (val=='' || val== undefined)){
					models[rowIndex].set("malPracticeStatus",""+record.data.examMalPracticType);
					return record.data.examMalPracticType;
				} else if(val!='' && val!= undefined){
					models[rowIndex].set("malPracticeStatus",""+val);
					return val;
				} else {
					if(record.get('presentAbsId') == 'Absent') {
						return "";
					}
					else {
						rec.tdCls = 'gridInputCustomStyle'; 
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}	
			/*} else {
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}*/
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			edit: function(obj, editor, context){
				 var this$= this;
			   	 var grid = obj.grid;
			   	 var store = grid.getStore();
			   	 var flag=true;
			   	 var models = grid.getStore().getRange();
			     var gridCount = Ext.getCmp('schemewiseattendancesummaryId');
			   	 for(var i =0; i<store.data.length;i++){
			   		 if(editor.rowIdx==i){
			   			 /*if(editor.value=="Absent"){
			   				models[i].set("presentAbsId","Absent");
			   				models[i].set("malPracticeStatus",null);
			   				models[i].set("malPracticeId",null);
				   		 } else if(editor.originalValue=="Present") {*/
			   			var malPracticeData = grid.getMlpData();
			   			if(editor.value=="Absent"){
			   				models[i].set("malPracticeId",null);
			   			} else {
			   			 for(var j in malPracticeData){
			   				 if(store.data.items[i].data.malPracticeStatus==malPracticeData[j].data.value){
			   					models[i].set("malPracticeId",malPracticeData[j].data.id);
			   					 models[i].set("malPracticeStatus",malPracticeData[j].data.value);
			   					 break;
			   				 }
			   			 }
			   			}
				   			
		   					
				   		 //}
				   		 /*if(!isNullOrEmpty(store.data.items[i].data.malPracticeStatus) && store.data.items[i].data.malPracticeStatus!="Click to enter"){
				   			var malPracticeData = grid.getMlpData();
				   			 for(var j in malPracticeData){
				   				 if(store.data.items[i].data.malPracticeStatus==malPracticeData[j].data.value){
				   					models[i].set("malPracticeId",malPracticeData[j].data.id);
				   					 models[i].set("malPracticeStatus",malPracticeData[j].data.value);
				   				 }
				   			 }*/
				   			/* if(flag){
				   				models[i].set("presentAbsId","Present");
				   			 } else {
				   				models[i].set("presentAbsId","Absent");
				   				models[i].set("malPracticeStatus",null);
				   				models[i].set("malPracticeId",null);
				   			 }*/
				   			 
			   			models[i].set('present', false);
	                	 models[i].set('absent', false);
            			  Ext.defer(function() {
	                		var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
	        				   for(var i =0; i<store.data.length;i++){
	        					   if(models[i].data.presentAbsId=="Present"){
	        						   preCount++;
		        					   presentSummaryCount++;
	        					   }
	        					   if(models[i].data.presentAbsId=="Absent"){
	        						   absCount++;
		        					   absentSummaryCount++;
	        					   }
	        					   if(models[i].data.attendanceStatus){
	        						   other++;
	        						   var data  = this.grid.columnManager.columns[6].field.getStore().data.items;
		        					   	for(var j= 0; j<data.length;j++){
		        					   		if(data[j].data.value == models[i].data.attendanceStatus){
		        					   			if(data[j].data.code == 'PRESENT')
		        					   				presentSummaryCount++;
		        					   			if(data[j].data.code == 'ABSENT')
		        					   				absentSummaryCount++;
		        					   			models[i].set('attendanceMarkingType' ,data[j].data.id);
		        					   			models[i].set('attendanceMarkStatus' ,data[j].data.code);
		        					   		}
		        					   	}
	        					   }
	        				   }
  	                	   var  data = {
  	                			   totalStudent:store.data.length,
  	                			   totalPresent:preCount,
  	                			   totalAbsent:absCount,
  	                			   otherCount:other,
  	                			   presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
  	                			   absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
  	                	   };
  	                	   var gridStore =  gridCount.getStore();
  		            		gridStore.removeAll();
  		            		gridStore.loadRawData(data, true);
	                		
						  }, 50, this);
						break;
					}
				}
			},
			beforeedit: function(editor, context, e) {
				if (editor.context.record.get('presentAbsId') == 'Absent' && context.colIdx == 11) {
					return false;
				}
			}
		}
	}]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}
});
