/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.examlogistic.StudentLogisticFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.studentlogisticfilter',
    autoScroll: false,   
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'academyLocation',
            itemId: 'academyLocationIdExamAttend',
            autoloadStore: false,
            width: 536,
            fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
            valueField: 'id',
            displayField: 'value',
            editable: false,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
      	  	allowBlank:false,
            emptyText: getCommonTranslation('PLEASE_SELECT_DROPDOWN_VALUE'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    },
                    afterRender: function (combo) {
                        combo.getStore().on("load", function (store, items) {
                            try {
                                if (items.length == 0)
                                    Ext.select('.x-boundlist-item').elements[0].hidden = true;
                                else
                                    Ext.select('.x-boundlist-item').elements[0].hidden = false;
                            } catch (err) {
                                console.log(err);
                            }
                        });
                    }
                },
                cls: 'combo-word-break-all',
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }]
    },{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	defaults: {
            		width: 256,
            		labelAlign: 'top'
            	},
            	items: [{
        			xtype: 'customcombobox',
        			name: 'studentId',
        			itemId: 'studentItemId',
        			store:'examinationcenters.reports.ExaminationReportStudentStore',
        			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
        			valueField: 'id',
        			displayField: 'valueCode',
        			queryParam:'name',
        			minChars:3,
        			allowBlank:false,
        			width: 536,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				}
        			}
        		},{
                	xtype: 'customcombobox',
                    name: 'courseVariant',
                    itemId:'courseVariantItemId',
                    store:'examinationcenters.reports.ExaminationReportCVStore',
                    displayField:'value',
                    queryParam:'name',
                    valueField:'id',
                    width: 256,
                    minChars:3,
                    typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			disabled:true,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{code}' +
        					'</div>';
        				}
        			},
                    fieldLabel:getExaminationTranslation('COURSE_VARIANT')
                }]
            },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
			xtype: 'customcombobox',
			name: 'evaluationPlanId',
			itemId: 'evaluationPlanItemId',
			store:'examinationcenters.reports.ExaminationReportEPStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
//			allowBlank:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
            xtype: 'groupingcombobox',
            name: 'evalPlanLevelId',
            itemId:'evalPlanLevelItemId',
            labelAlign:'top',
           // queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
           // valueField: 'id' ,
            minChar : 3,
			disabled:true,
            forceSelection:true,
        },{
			xtype: 'customcombobox',
			name: 'eventId',
			itemId: 'eventItemId',
			//store:'examinationcenters.reports.EventForAttendanceStore',
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventByEvalPlan'),
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'searchText',
			minChars:3,
			width: 256,
//			allowBlank:false,
			disabled:true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});