/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.examlogistic.studentattendance.StudentAttendanceEvalPlanFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.studentattendanceevalplanfilter',
    autoScroll: false,
    frame: false,
	//cls:'customSearchPanel',
    items: [{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'evaluationPlanType',
    		itemId:'evalPlanTypeItemId',
    	    store:'examCenter.AssignSequence.EvaluationType',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
    		allowBlank:false
    	},{
    		xtype: 'customcombobox',
    		name: 'evalStage_1',
    		itemId:'evalStage_1',
    		fieldLabel: getExaminationTranslation('EVALUATION_STAGE'),
    		store: 'examinationcenters.CenterUseFor',
    		displayField: 'value',
    		valueField: 'id',
    		typeAhead: true,
    		disabled:true,
    		allowBlank:false
    	},{
    		xtype: 'customcombobox',
    		name: 'evalStage_2',
    		itemId:'evalStage_2',
    		fieldLabel: getExaminationTranslation('EVALUATION_STAGE'),
    		store: 'examinationcenters.evaluation.PlacementAcademyOthers',
    		displayField: 'value',
    		valueField: 'id',
    		typeAhead: true,
    		hidden:true,
    		disabled:true,
    		allowBlank:true
    	}]
    	    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		
    		xtype: 'customcombobox',
			name:'program',
			itemId:'programItemId',
			store:'common.ProgramStore',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			width: 536,
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			//hidden:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
    		
    		/*xtype: 'customcombobox',
    		name: 'program',
    		itemId:'programItemId',
    		store:'common.ProgramStore',
    		displayField:'value',
    		valueField:'id',
    		width: 536,
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('PROGRAM'),
    		allowBlank:false*/
    	},{
    		xtype: 'customcombobox',
    		name: 'batch',
    		itemId:'batchItemId',
    		store:'common.BatchesByProgramId',
    		displayField:'value',
    		valueField:'id',
    		typeAhead:true,
    		//hidden:true,
    		fieldLabel:getExaminationTranslation('BATCH'),
    		disabled:true,
    		allowBlank:false
    	}]
    	 },{

    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		
    		xtype: 'customcombobox',
			name:'course',
			itemId:'courseItemId',
			store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
			fieldLabel: getCommonTranslation('COURSE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			width: 536,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
    		/*xtype: 'customcombobox',
    		name: 'course',
    		store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
    		displayField:'value',
    		valueField:'id',
    		itemId:'courseItemId',
    		width: 536,
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('COURSE'),
    		disabled:true,
    		allowBlank:false*/
    	},{
			 xtype: 'customcombobox',
		     name: 'periodId',
		     fieldLabel: getExaminationTranslation('PERIOD'),
		     store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		     displayField:'value',
		     valueField:'id',
		     forceSelection:true,
		     typeAhead:true,
		     disabled:true,
		     itemId:'periodIdItemId',
		     allowBlank: true,
		     hidden:true
		},{
			 xtype: 'customcombobox',
		     name: 'sectionId',
		     itemId:'sectionIdItemId',
		     fieldLabel: getExaminationTranslation('SECTION'),
		     store:'coursetransaction.sectionmanagement.SectionsStore',
		     displayField:'value',
		     valueField:'id',
		    // forceSelection:true,
		     typeAhead:true,
		     disabled:true,
		     allowBlank: true,
		     hidden:true
		},{
			
			xtype: 'customcombobox',
			name:'evaluationPlanOther',
			itemId:'evaluationPlanOtherItemId',
			store:'examinationcenters.examlogistic.EvalPlanByPeriodSection',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'evaluationPlanId',
			displayField: 'evaluationPlanNumber',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			allowBlank:true,
			hidden:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{evaluationPlanNumber}' +
					'</div>';
				}
			}
    		/*xtype: 'customcombobox',
    		name: 'evaluationPlanOther',
    	    store:'examinationcenters.examlogistic.EvalPlanByPeriodSection',
    		displayField:'evaluationPlanNumber',
    		valueField:'evaluationPlanId',
    		itemId:'evaluationPlanOtherItemId',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
    		disabled:true,
    		hidden:true,
    		allowBlank:true*/
    	},{
    		
    		xtype: 'customcombobox',
			name:'evaluationPlan',
			itemId:'evaluationPlanItemId',
			store:'examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			allowBlank:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
    	/*	xtype: 'customcombobox',
    		name: 'evaluationPlan',
    	    store:'examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo',
    		displayField:'value',
    		valueField:'id',
    		itemId:'evaluationPlanItemId',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
    		disabled:true,
    		allowBlank:false*/
    	}]

    	 },{

    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'detailedSequence',
    		store:'servicerequest.examrelatedrequest.DetailEvaluationSequences',
    		displayField:'value',
    		valueField:'id',
    		width: 536,
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
    		disabled:true,
    		allowBlank:false
    	}]

    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		} ]	
	}]
});