/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.examresultpublish.ExamResultPublishFilter',{
	extend : 'Ext.form.FormPanel',
	alias:'widget.examresultpublishfilter',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'multiselectcombofield',
			name : 'academyLocation',
			itemId:'academyLocationId',
			autoloadStore: false,
			addAllSelector: false,
			width: 536,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			editable:false,
			//queryParam:'qry',
			//minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('PLEASE_SELECT_DROPDOWN_VALUE'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							try {
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							}
							catch(err) {
								console.log(err);
							}
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
//			width: 256,
			ueryMode:'local',
			queryMode:'local',
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.BatchIntakeYearStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:'examinationcenters.reports.ExaminationReportStudentStore',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			minChars:3,
			width: 536,
			queryParam:'name',
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					} 
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:'examinationcenters.reports.ExamResultPublishProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueSecondValue',
			queryParam:'name',
			minChars:3,
			width: 256,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'examinationcenters.reports.ExamResultPublishBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			disabled:true,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
		    store:'examinationcenters.reports.SpecialGradePeriodStore',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			width: 256,
			typeAhead:false,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
		}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'evaluationPlanId',
			itemId: 'evaluationPlanId',
			store:'examinationcenters.reports.ExaminationPlanStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{valueCode}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
    		name: 'evaluationLevel',
    		itemId: 'evaluationLevelItemId',
    	    store:'examinationcenters.marksheet.EventEvaluationLevelType',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		querymode:'local',
    		minChars:3,
    		disabled:true,
    		allowBlank:false,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
    	},{
       		xtype: 'customcombobox',
       		name: 'evaluationLevelName',
       		itemId: 'evaluationLevelNameId',
       		store:'examinationcenters.calculateAverage.ExamPublishResultLevelTypeStore',
//       		store:'examinationcenters.calculateAverage.EvaluationPlanLevelNameStore',
       		fieldLabel : getExaminationTranslation('EVALUATION_PLAN_LEVEL_NAME'),
       		displayField:'value',
       		valueField:'id',
       		disabled:true,
       		forceSelection:true,	
    		typeAhead:true,
       	}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important',paddingTop:'25px!important'},
		width:'100%',
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 536
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'sectionId',
				itemId: 'sectionItemId',
				disabled:true,
				store:'attendance.SectionAndFacultyByPeriodID',
				fieldLabel:getExaminationTranslation('SECTION'),
				valueField: 'sectionId',
				displayField: 'sectionCode',
				width: 536,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				cls:'resetPasswordMultiselect',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
							
						}
					},
				}
			}]

		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'courseId',
				itemId: 'courseItemId',
				store:'examinationcenters.reports.ExaminationResultPublishCourseStore',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 536,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
	        	xtype: 'customcombobox',
	            name: 'courseVariant',
	            itemId:'courseVariantItemId',
	            store:'facilitiesresources.resourcebooking.ExamResultPublishCourseVariantsStore',
	            displayField:'code',
	            queryParam:'courseName',
	            valueField:'id',
	            width: 256,
	            minChars:3,
	            typeAhead:false,
	            disabled:true,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
	            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
	        }]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'resultPublishStatus',
				itemId: 'resultPublishStatusId',
				store:'examinationcenters.examresultpublish.ExamResultPublishStatusStore',
				fieldLabel:getExaminationTranslation('RESULT_PUBLISH_STATUS'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				width: 256,
				typeAhead : true,
				forceSelection : true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'facultyName',
				itemId: 'facultyItemId',
				store:'coursetransaction.facultytopicassignment.AssignFacultyStore',
				fieldLabel:getCommonTranslation('FACULTY_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				width: 256,
				disabled:true,
				typeAhead : true,
				forceSelection : true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}]
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
