/**
 * @author Anand Verma
 */
Ext.define('Academia.view.examinationcenters.examstaffallocation.ExamStaffAllocationForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.examstaffallocationform',
	autoScroll: false,
	frame:false,
	plugins : "formlabelrequired",
	
	items: [{xtype:'form',
		cls:'customSearchPanel',		
		items: [{
	xtype: 'fieldcontainer',
	layout: 'hbox',
	style :{marginLeft: '10px'},
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype: 'customcombobox',
		name: 'userId',
		itemId:'userItemId',
		width: 256,
		fieldLabel:getExaminationTranslation('USER'),
		store:'examinationcenters.examstaffallocation.ExaminationStaff',
		valueField: 'id',
		displayField: 'value',
		queryParam:'name',
//		hidden:true,
		minChars:3,
		typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		allowBlank:false,
		width: 256,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		}
	},{
		xtype: 'customcombobox',
		name: 'role',
		itemId:'roleItemId',
		fieldLabel: getExaminationTranslation('ROLE'),
		store:'examinationcenters.examstaffallocation.ExamRoles',
		displayField: 'value',
		valueField: 'id',
		typeAhead: true,	  
		allowBlank:false,
		disabled:true
	},{
		xtype: 'customcombobox',
		name: 'evaluationGroupId',
		itemId:'evaluationGroupItemId',
		store:'examinationcenters.examstaffallocation.commonFilter.ExamGroupFilter',
		displayField:'value',
		valueField:'id',
		allowBlank:false,
		forceSelection:true,
		typeAhead:true,
		fieldLabel:getExaminationTranslation('CNTRL_ERL_EVAL_GROUP'),
		disabled:true
	},{
		xtype: 'label',
		name:'msgName',
		itemId: 'msgItemId',
		hidden:true,
		width:480,
		value:''+getExaminationTranslation('GROUP_ASSOCIATION_MSG'),
		text:''+getExaminationTranslation('GROUP_ASSOCIATION_MSG'),
		style: {
			'color':'red',
			'marginTop':'35px'
		}
	}]
},{
	xtype: 'fieldcontainer',
	layout: 'hbox',
	style :{marginLeft: '10px'},
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
    	xtype: 'customcombobox',
        name: 'evaluationType',
        itemId:'evaluationTypeItemId',
        store:'examCenter.AssignSequence.EvaluationType',
        displayField:'value',
        valueField:'id',
        forceSelection:true,
        editable:false,
        typeAhead:true,
        disabled:true,
        fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
        allowBlank: false
    },{
		xtype: 'customcombobox',
		name:'courseId',
		itemId:'courseIdItemId',
		store: 'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter',
		fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
		valueField: 'id',
		displayField: 'value',
		queryParam:'textSearch',
		minChars:3,
		typeAhead:false,
		allowBlank:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		disabled:true,
		width: 256,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			}
		}
	},{
		xtype: 'customcombobox',
		name: 'courseVariantsId',
		itemId: 'courseVariantsIdItemId',
		fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
		store:'examinationcenters.examstaffallocation.commonFilter.ExamCVFilter',
		valueField: 'id',
		displayField: 'value',
		queryParam:'textSearch',
		minChars:3,
		typeAhead:false,
//		hidden:true,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		disabled:true,
		width: 256,
		allowBlank:false,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			}
		}
	}]
},{
	xtype: 'fieldcontainer',
	layout: 'hbox',
	style :{marginLeft: '10px'},
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype: 'customcombobox',
		name: 'periodId',
		itemId: 'periodItemId',
		width: 256,
		fieldLabel:getExaminationTranslation('PERIOD'),
		store:'examinationcenters.examstaffallocation.commonFilter.ExamPeriodFilter',
		valueField: 'id',
//		hidden:true,
		displayField: 'value',
		queryParam:'textSearch',
		minChars:3,
		typeAhead:false,
		allowBlank:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		disabled:true,
		width: 256,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			}
		}
	},{
		xtype: 'customcombobox',
		name: 'sectionId',
		itemId: 'sectionIdItemId',
		width: 256,
		fieldLabel:getExaminationTranslation('SECTION'),
		store:'examinationcenters.examstaffallocation.commonFilter.ExamSectionFilter',
		valueField: 'id',
//		hidden:true,
		displayField: 'value',
		queryParam:'textSearch',
		minChars:3,
		typeAhead:false,
		allowBlank:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		disabled:true,
		width: 256,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			}
		}
	},{
		xtype: 'customcombobox',
		name: 'centerName',
		itemId: 'centerNameItemId',
		fieldLabel: getExaminationTranslation('CENTER_NAME'),
		store: 'examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter',
		displayField: 'valueCode',
		valueField: 'id',
		allowBlank:false,
		typeAhead: true,
		disabled:true
	}]
},{
	xtype: 'fieldcontainer',
	layout: 'hbox',
	style :{marginLeft: '10px'},
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype: 'customcombobox',
		name: 'eventsId',
		width: 256,
		fieldLabel:getExaminationTranslation('DETAIL_SEQUENCE'),
		store:'examinationcenters.examstaffallocation.commonFilter.ExamEventFilter',
		valueField: 'id',
		displayField: 'value',
		allowBlank:false,
		queryParam:'textSearch',
		minChars:3,
		typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		disabled:true,
		width: 256,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		}
	}]
},{
	xtype: 'fieldcontainer',
	layout : {
		type : 'hbox'
	},
	cls: 'customSearchPanelBtnsFieldContainerCls',
	items : [{
		xtype: 'button',
		itemId:'searchBtn',		
		text: getCommonTranslation('SEARCH'),
		ui: 'CustomBtnSubmit',		
		scale: CONSTANTS.BUTTONSIZE,
		//align: 'left',
		formBind:true
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId:'resetBtn',
		ui: 'CustomBtnCancel',
		scale: CONSTANTS.BUTTONSIZE
	}]
}]
	},{
		xtype: 'fieldcontainer',
		defaults: {
			labelAlign: 'top'
		},
		
		items : [{
			xtype:'staffeventallocationgrid',
			margin:'0 0 0 0',
			padding:'10'
			}]
	
	}]
});