/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateCrossListReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.generatecrosslistreportwin',
	title:getExaminationTranslation('GENERATE_REPORT'),
	modal: true,
//	autoScroll:true,
	maxHeight:500,
	width: '40%',
	height:'20%',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
				xtype: 'fieldcontainer',
				width: '100%',
				layout: {
					type: 'hbox',
					width: 415
				},
				items: [{
					xtype: 'customcombobox',
					name: 'evaluationGroupId',
					itemId: 'evaluationGroupItemId',
					store:'examinationcenters.evalresultlisting.EvaluationGroupByProgBatch',
					displayField:'value',
					valueField:'id',
					forceSelection:true,
					width: 415,
					typeAhead:true,
					fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
					listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				}
	    			},
				}]
			},{
				xtype: 'fieldcontainer',
				layout: {
					type: 'hbox',
					width: 256
				},
				items: [{
	            	xtype: 'customcombobox',
	            	itemId:'chooseTemplate',
	        		name: 'chooseTemplateId',
	        	    store:'setup.templatemapping.TemplateNameForFoils',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
	        		displayField:'code',
	        		valueField:'id',
	        		width:310,  
	        		forceSelection:true,
	        		typeAhead:true,
	        		minChars:3,
	        		listConfig: {
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{value}' +
	    					'</div>';
	    				},
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				}
	    			},
	        		allowBlank:false,
	        		fieldLabel:getExaminationTranslation('TEMPLATE')
            },{
    	        xtype: 'fieldcontainer',
            	layout: 'hbox',
            	items:[{
            		xtype: 'button',
        			text:'Preview Template',
        			itemId: 'previewTemplateBtn',
        			buttonAlign: 'bottom',
        			ui: 'CustomBtnThird',
        			scale: CONSTANTS.BUTTONSIZE,
        			//hidden:true
        			formBind:true
            	}]
    		}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
                }
            }]
		}]
	}]
});