/**
 * @author sumit meena
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.FacultyEvaluationPlanFilter', {
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.facultyevaluationplanfilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	plugins:"formlabelrequired",
	cls:'customSearchInnerPanel',
	items: [{
		xtype:'hidden',
		itemId: 'HiddenCourseVar'
	},{
		xtype:'hidden',
		itemId: 'HiddenEvnt'
	},{
			xtype:'hidden',
			itemId: 'anonymousEvnt'
		
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evaluationType',
			itemId:'evaluationTypeItemId',
			store:Ext.create('Academia.store.examCenter.AssignSequence.EvaluationType'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name:'evaluationStage',
			store:'examinationcenters.CenterUseFor',
			itemId:'evaluationStageItemId',
			fieldLabel: getExaminationTranslation('EVALUATION_STAGE'),
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
//			allowBlank: false
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTermId',
			displayField : 'value',
			valueField : 'id',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			typeAhead : true,
			forceSelection : true,
			/*listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.examinationcenters.reports.marksheet.MarksheetReportAcademicTermStore');
					combo.bindStore(store)
				}
			}*/
		},{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationProgramStore'),
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'programName',
			minChars:3,
			//width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			hidden:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'courseVariant',
			itemId:'courseVariantItemId',
			store:Ext.create('Academia.store.attendance.VariantMappedToPlan'),
			displayField:'value',
			valueField:'id',
			queryParam:'name',
			width: 256,
			minChars:3,
			maxLength:9999,
			maxSelections :9999,
			forceSelection:true,
			allowBlank:false,
			typeAhead:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			},
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			//disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchStore'),
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			hidden:true,
			disabled:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('BATCH')
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodStore'),
			displayField:'value',
			valueField:'id',
			//forceSelection:true,
			typeAhead:true,
			disabled:true,
			hidden:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('PERIOD')
		},{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId:'sectionIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionStore'),
			displayField:'value',
			valueField:'id',
			width: 256,
			disabled:true,
			//forceSelection:true,
			typeAhead:true,
			hidden:true,
			allowBlank:false,
			fieldLabel:getExaminationTranslation('SECTION')
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'evalautionPlan',
			itemId:'evalautionPlanItemId',
			store:Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanByCriteria'),
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			width: 256,
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			disabled:true,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}

		},{
			xtype : 'radiogroup',
			fieldLabel:getExaminationTranslation('ANONYMOUS_EVALUATION_EVENT'),
			itemId:'anonymousEvent',
			labelAlign : 'top',
			hidden:true,
			items : [{
				boxLabel : getExaminationTranslation('YES'),
				name:'anonymousEvent',
				inputValue: true//,
				//id:'anonymousEventYesId'
			},{
				boxLabel : getExaminationTranslation('NO'),
				name:'anonymousEvent',
				inputValue: false,
				checked : true//,
				//id:'anonymousEventNoId'
			}]
		},{
			xtype:'hidden',
			name:'evaluationEventStatus'
		},{
			xtype:'hidden',
			name:'isDynamicScheme'
	},{
			xtype: 'customcombobox',
			name:'evalautionPlanNo',
			itemId:'evalautionPlanNoItemId',
			store:'examinationcenters.evaluationgroup.detailsequencecovered.EvalGroupEvaluationPlanCombo',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			hidden:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
            xtype: 'groupingcombobox',
            name: 'evalPlanLevelId',
            itemId:'evalPlanLevelItemId',
            labelAlign:'top',
            queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store:Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            valueField: 'levelId' ,
            minChar : 3,
            disabled:true,
            allowBlank: true,
            /*listeners:{
            	select:function(obj,rec){
            		var data=rec[0].data.code;
            	}
            }*/
        },{
			xtype: 'customcombobox',
			name: 'detailSequence',
			itemId:'detailSequenceItemId',
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventByEvalPlan'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			disabled:true,
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			allowBlank: false,
        },{
        	xtype: 'fieldcontainer',
        	width: '100%',
        	layout: 'hbox',
        	defaults: {
        		fieldStyle:'font-weight: bold;',
        		labelStyle:'margin-top:10px; font-weight: bold;',
        		labelAlign: 'left'
        	},
        	items: [{
        		xtype: 'displayfield',
        		name:'minMarksGradeId',
        		itemId:'minMarksGradeId',
        		labelWidth: 125,
        		width:170,
        		fieldLabel: getExaminationTranslation('MIN_MARKS_GRADE'),
        		fieldStyle:'font-weight: bold;',
        		labelStyle:'margin-top:10px;margin-right: 8px; font-weight: bold;',
        		labelAlign: 'left',
        		margin: '26 0 0 0'
        	}, {
        		xtype: 'displayfield',
        		name:'maxMarksGradeId',
        		itemId:'maxMarksGradeId',
        		labelWidth: 125,
        		width:170,
        		fieldLabel: getExaminationTranslation('MAX_MARKS_GRADE'),
        		fieldStyle:'font-weight: bold;',
        		labelStyle:'margin-top:10px;margin-right: 8px; font-weight: bold;',
        		labelAlign: 'left',
        		margin: '26 0 0 0'
        	}, {
        		xtype: 'displayfield',
        		itemId:'weightageId',
        		name:'weightageId',
        		labelWidth: 75,
        		width:175,
        		fieldLabel: getExaminationTranslation('WEIGHTAGE'),
        		fieldStyle:'font-weight: bold;',
        		labelStyle:'margin-top:10px;margin-right: 8px;font-weight: bold;',
        		labelAlign: 'left',
        		margin: '26 0 0 0'
        	}]
        }]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		style: {
			marginLeft: '-32px !important;'
		},
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype:'button',
			itemId:'markEntryDownload',
			hidden:true,
			text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
			ui: 'CustomBtnSubmit'
		},{
			xtype:'button',
			itemId:'markEntryUpload',
			text:getExaminationTranslation('MARK_ENTRY_UPLOAD'),
			ui : 'CustomBtnThird',
			hidden:true
		},{
            xtype: 'button',
            text: getExaminationTranslation('GENERATE_FOILS_REPORT'),
            itemId:'generateFoils',
            ui: 'CustomBtnThird',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true,
            cls: 'btn-with-no-icon'
		}]
	}]
});
