/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.MarkEntryDefaultMarkGradeWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.markentrydefaultmarkgradewindow',
	title:getExaminationTranslation('ENTER_DEFAULT_MARKS'),
	frame: true,
	autoScroll:false,
	modal:true,
	method: 'POST',
	maxHeight: 800,
	width: 325,
	height: 225,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		/*layout: {
			type: 'vbox'
		},*/
		defaults: {
			labelAlign: 'top',
			width:220
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name:'marksOrGrade',
			itemId:'marksOrGrade',
		},{
			xtype: 'customcombobox',
			name:'defaultFinalGrade',
			itemId:'defaultFinalGrade',
			store:'gradeMaster.GradeGroupMapping',
			valueField:'grade',
			displayField:'grade',
			editable:false,
			hidden:true,
			emptyText: getExaminationTranslation('SELECT_GRADE'),
		},{
			xtype: 'numberfield',
			name:'defaultTotalMarks',
			itemId:'defaultTotalMarks',
			minValue:0,
			maxValue:999,
			decimalPrecision:4,
			mouseWheelEnabled:false,
			hidden:true,
//			allowBlank: false,
			emptyText: getExaminationTranslation('ENTER_DEFAULT_MARKS'), 
			listeners: {
			                change: function(val, newVal, oldVal) { 
			                	//var maxMarksAssignment = this.maxValue;
								var check=val.up('window');  
			                    if (check.whetherRoundedMark) {
									if(!isNaN(newVal) && newVal % 1 !== 0){
										showWarningMessage(getCommonTranslation('ALERT'), 'Mark Entry with Decimal not allowed');
										val.reset();  
										return "Invalid Selection";  
									}
									}
			                }
			            }
		},{
			xtype: 'textfield',
			name:'textGrade',
			itemId:'textGradeItemId',
			hidden:true,
			emptyText: getExaminationTranslation('SELECT_GRADE'),
		},{
			xtype: 'numberfield',
			name:'textGrade1',
			itemId: 'textGradeItemId1',
			minValue:0,
			maxValue:999,
			decimalPrecision:4,
			mouseWheelEnabled:false,
			hidden:true,
			//allowBlank: false,  
			emptyText: getExaminationTranslation('SELECT_GRADE'),
			listeners: {
                change: function(val, newVal, oldVal) {
                	var maxMarksAssignment = this.maxValue;
                    if (maxMarksAssignment < newVal) {
                        showWarningMessage(getCommonTranslation("ALERT"), getCommonTranslation("Minumum marks cannot be grater than maximum marks "))
                    }
                }
            }
		},{ 	
		   xtype:'fieldcontainer',
    	   width:'auto',
    	   style: {
               marginTop: '10px',
           },
          
		   items: [{
		    	 xtype: 'button',
				 action: 'Submit',
				 text: getFeeAndPaymentCommonTranslation('SAVE'),
				 formBind: true,
				 itemId: 'submitBtnWin',
				 ui: 'CustomBtnSubmit',
				 scale: CONSTANTS.BUTTONSIZE
		      },{
				 xtype: 'button',
				 text: getFeeAndPaymentCommonTranslation('CANCEL'),
				 ui: 'CustomBtnCancel',
				 itemId: 'cancelBtn',
				 scale: CONSTANTS.BUTTONSIZE
		      }]
	       }]
		}]	
});
