/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.markgrade.MarkGradeMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.markgrademastergrid',
    store: 'examinationcenters.markgrade.MarkGradeMasterGridStore',
	title : getProgramandcourseTranslation('COURSE_LIST'),
    border: true,
	refreshStoreData:true,
    frame:false,
  //  selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.markgrade.MarkGradeMasterGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    },
    {
        xtype: 'button',
        itemId: 'approveLinked',
        disabled:true,
        text:getExaminationTranslation('APPROVE'),
    },
	{
        xtype: 'button',
        itemId: 'resetGradeStatusBtn',
        disabled:true,
        text:getExaminationTranslation('RESET_GRADE_STATUS'),
    },
    /*{
	    xtype : 'splitbutton',
	    itemId:'spBtnMoreActions',
	    text : getCommonTranslation('MOREACTIONS'),
	    menu:[{
		text:getExaminationTranslation('APPROVE'),
		itemId:'approveLinked'
	    }],
	    listeners: { click: function() { this.showMenu(); } }
    }*/],
    columns: [{
        header: getExaminationTranslation('COURSE'),
        dataIndex: 'courseName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'totalCourseVaraint',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.raw.maxGrade)){
        		return "<a href='#'>"+record.raw.totalCourseVaraint+"</a>";
        	}else{
        		return "-";
        	}
        } 
    },{
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicTerm',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('MAX_GRADE_OBTAINED'),
        dataIndex: 'maxGrade',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.raw.maxGrade)){
        		return "<a href='#'>"+record.raw.maxGrade+"</a>";
        	}else{
        		return "-";
        	}
        }  
    },/*{
        header: getExaminationTranslation('DETAIL_SEQUENCE'),
        dataIndex: 'detailSequenceNumber',
        flex:.3,
        sortable: true,
        hidden:true
    },*/ /*{
        header: getExaminationTranslation('MARKS_GRADES'),
        dataIndex: 'evalInMarksOrGrade',
        flex:.3,
        sortable: true
    },*/{
        header: getExaminationTranslation('GRADE_DEFINITION'),
        dataIndex: 'distributionStatus',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.distributionStatus)){
        		if(record.data.distributionStatus == 'Pending') {
        			return getExaminationTranslation('CNTRL_PENDING');
        		} else if (record.data.distributionStatus == 'DRAFT') {
        			return getCommonTranslation('DRAFT');
        		} else if (record.data.distributionStatus == 'APPROVED') {
        			return getCommonTranslation('COMPLETED');
        		}
        		
        	}	
        }  
    },{
        header: getExaminationTranslation('APPROVAL'),
        dataIndex: 'approvalStatus',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.approvalStatus)){
        		if(record.data.approvalStatus == 'Pending') {
        			return getExaminationTranslation('CNTRL_PENDING');
        		} else if (record.data.approvalStatus == 'DRAFT') {
        			return getCommonTranslation('DRAFT');
        		} else if (record.data.approvalStatus == 'APPROVED') {
        			return getCommonTranslation('APROVED');
        		}
        		
        	}	
        }  
    },]
});