/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.preExamDetail.UploadPreExamDetailFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.uploadPreExamDetailFilter',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
    	xtype: 'hidden',
    	name: 'assessmentSchemeId'
    }, {
    	xtype: 'hidden',
    	name: 'courseIds'
    }, {
    	xtype: 'hidden',
    	name: 'assessmentEventIds'
    }, {
    	xtype: 'hidden',
    	name: 'assessmentLevelSelected'
    }, {
		xtype: 'customcombobox',
		name:'templateFor',
		itemId:'uploadTemplateForItemId',
		store: Ext.create('Ext.data.Store', {
			fields: [
		    	'id',
		    	'value',
		    	'displayValue'
		    ],
		    data: [{
		    	displayValue: getCommonTranslation('ImportAdministeredBy'),
		    	value: 'Import Administered By'
		    }, {
		    	displayValue: getCommonTranslation('ImportInvigilators'),
		    	value: 'Import Invigilators'
		    }, {
		    	displayValue: getCommonTranslation('ImportConcessionAllocation'),
		    	value: 'Import Concession Allocation'
		    }, {
		    	displayValue: getCommonTranslation('ImportNonConcessionAllocation'),
		    	value: 'Import Non Concession Allocation'
		    }]
		}),
		fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),
		width: 256,
        labelAlign: 'top',
		valueField: 'displayValue',
		displayField: 'displayValue',
		typeAhead:false,
		allowBlank:false,
		forceSelection: true,
		editable: false,
		listConfig: {
            listeners: {
                beforeshow: function (picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                    picker.maxWidth = picker.up('combobox').getSize().width;
                }
            },
            loadingText: getCommonTranslation('SEARCHING'),
            emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            getInnerTpl: function () {
                return '<div class="search-item">' +
                    '{value}' +
                    '</div>';
            }
        }
	}, {
		xtype: 'customcombobox',
		name: 'importUtilityMasterId',
		itemId:'moduleNamePreExamDetail',
		labelAlign: 'top',
		store:'importutility.ModuleName',
		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		valueField: 'id',
		readOnly:true,
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false,
		hidden: true
	}, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        hidden: true,
        disabled: true,
        itemId: 'container1',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'academicTermId',
            itemId: 'preExamDetailAcademicTermId',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            store: Ext.create('Academia.store.common.AcademicTermStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            typeAhead: true,
    		editable: false,
            allowBlank: false
        }, {
            xtype: 'multiselectcombofield',
            name: 'schemeId',
            itemId: 'preExamDetailAssesmentSchemeId',
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.EvalPlanStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            width: 256,
            displayField: 'evaluationPlanNumber',
            typeAhead: false,
            disabled: true,
            allowBlank: false,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            forceSelection: true,
    		autoloadStore: false,
    		submitValue: false,
    		cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        hidden: true,
        disabled: true,
        itemId: 'container2',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'courseId',
            itemId: 'preExamDetailCourseItemId',
            labelAlign: 'top',
            fieldLabel: getExaminationTranslation('COURSE_CODE_NAME'),
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.CoursesStore'),
            valueField: 'id',
            displayField: 'displayValue',
            queryParam: 'courseName',
            autoloadStore: false,
            disabled: true,
            typeAhead: false,
            forceSelection: true,
            matchFieldWidth: true,
            submitValue: false,
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }, /*{
            xtype: 'groupingcombobox',
            name: 'assessmentSchemeLevelId',
            itemId: 'preExamDetailEvaluationLevelNameId',
            labelAlign: 'top',
            groupField: 'code',
            groupDisplayField: 'code',
            valueField: 'levelId',
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.EvalPlanLevels'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            disabled: true,
            forceSelection: true,
    		editable: false
        }*/{
            xtype: 'multiselectcombofield',
            name: 'detailSequence',
            itemId: 'preExamDetailDetailSequenceItemId',
            disabled: true,
            cls: 'receiptHeaderMultiselect resetPasswordMultiselect',
            displayField: 'eventName',
            valueField: 'eventId',
            forceSelection: true,
            store: Ext.create('Academia.store.examinationcenters.preExamDetails.EventsStore', {
            	autoloadStore: false
            }),
            queryMode: 'local',
            fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
            disabled: true,
            submitValue: false,
            autoloadStore: false,
            allowBlank: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 315,
        fieldLabel: getCommonTranslation('UPLOAD_FILE'),
        labelAlign: 'top',
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'uploadFileField',
        name: 'file',
        allowBlank: false,
        validateOnChange: true,
        listeners: {
            change: function (fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                        Ext.defer(function () {
                            fileField.errorEl.dom.style.visibility = 'visible';
                            fileField.errorEl.dom.style.display = 'block';
                        }, 1);
                    }
                }
            }
        }
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: getTranslation('UPLOAD_DATA'),
            formBind: true,
            itemId: 'preExamDetailUpload',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls:'CustomBtnSubmitToolbaar'
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'resetBtn',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
    	html: '<b><span style="color: red;">' + getCommonTranslation('NOTE') + ': </span>' + getExaminationTranslation('IMPORT_PRE_EXAM_DETAIL_NOTE_ADMINISTERED_BY') + '</b>',
    	margin: '8 10 0 -6',
    	cls: 'note-section',
    	hidden: true,
    	itemId: 'adminByNote'
    }, {
    	html: '<b><span style="color: red;">' + getCommonTranslation('NOTE') + ': </span>' + getExaminationTranslation('IMPORT_PRE_EXAM_DETAIL_NOTE_INVIGILATOR') + '</b>',
    	margin: '8 10 0 -6',
    	cls: 'note-section',
    	hidden: true,
    	itemId: 'invigilatorNote'
    }]
});