/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.remark.ClassTeacherRemarksFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.classteacherremarksfilter',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	items:[{ 
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
	},items:[{
		xtype:'hidden',
		name:'eventStatus',
		itemId: 'eventStatus',
		},{
		xtype: 'customcombobox',
		name:'userType',
		itemId:'userTypeId',
		store:'examinationcenters.remark.StudentRemarkUserTypeStore',
		fieldLabel:getCommonTranslation('USER_TYPE'),
		valueField: 'id',
		displayField: 'value',
		forceSelection:true,
		width: 256,
		typeAhead:false,
		allowBlank:false,
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		}
	},{
		xtype : 'customcombobox',
		name : 'academicTerm',
		itemId : 'academicTerm',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
		store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
		valueField : 'id',
		displayField : 'value',
		queryMode: 'local',
		minChars:'3',
		typeAhead:true,
		forceSelection:true,
		//hidden:true,
    },{
		xtype: 'customcombobox',
		name:'programId',
		itemId:'programItemId',
		//store:'common.AssignedProgramStore',
		store:'common.ClassTeacherProgramStore',
		fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		valueField: 'id',
		displayField: 'valueCode',
		queryParam:'name',
		minChars:3,
		typeAhead:true,
		//width: 536,
		allowBlank:false,
		//typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		/*listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		}*/
	}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'common.CurrentBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			queryParam:'batchName',
//			queryMode: 'local',
			minChars:'3',
			disabled:true,
			allowBlank:false,
			forceSelection : true,
			typeAhead:false,
			
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			queryParam: 'name',
//			queryMode: 'local',
			forceSelection : true,
			minChars:'3',
			typeAhead:false,
			allowBlank:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
    		xtype: 'multiselectcombofield',
    		name: 'sectionId',
    		itemId: 'sectionItemId',
    	    store:'attendance.SectionAndFacultyByPeriodID',
    		displayField:'sectionCode',
    		valueField:'sectionId',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('SECTION'),
			cls:'resetPasswordMultiselect',
    		width: 536,
    		autoloadStore: false,
    		disabled:true,
    		listConfig: {
  				listeners: {
 					beforeshow: function(picker) {
 						picker.minWidth = picker.up('combobox').getSize().width;
 					}
 				},
             }
    	}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
    		xtype: 'customcombobox',
    		name: 'evaluationLevel',
    		itemId: 'evaluationLevelItemId',
    	    store:'examinationcenters.marksheet.FindEvaluationLevelTypeNameByPeriodIdStore',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		queryMode:'local',
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
    		disabled:true,
    		allowBlank:false
    	},{
    		xtype: 'customcombobox',
    		name: 'evalLevelName',
    		itemId: 'evaluationLevelNameItemId',
//    	    store:'examinationcenters.marksheet.EvaluationLevelForTeacherRemarkStore',
    	    store:'examinationcenters.remark.EvaluationLevelForTeacherRemarkStore',
    	    displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:true,
    		queryMode:'local',
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
    		maxLength:1000000,
    		autoloadStore: false,
    		allowBlank:false,
    		disabled:true
    	},{
    		xtype: 'textfield',
    		name: 'remarkStatusId',
    		readOnly: true,
    		hidden:true,
    		fieldLabel:getExaminationTranslation('REMARK_STATUS')
    	}]},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
		}}, {
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			layout : {
				type : 'hbox'
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			},{
				xtype: 'button',
				itemId: 'studentLevelStatusBtnId',
				name:'studentLevelStatusBtn',
				disabled:true,
				formBind : true,
				text: getExaminationTranslation('MANAGE_REMARK_STATUS'),
				ui:'CustomBtnCancel',
				hidden:true,
				scale: CONSTANTS.BUTTONSIZE,
				cls: 'btn-with-no-icon'
			}]	
		}]});
