/**
 * @Sumit.meena
 */
Ext.define('Academia.view.examinationcenters.repetitioncompletion.ApproverWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.approverwindow',
    modal: true,
    autoScroll:true,
    title: getExaminationTranslation('ASSIGN_APPROVER'),
    width: '25%',
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true,
            width: 256
        },
        plugins:"formlabelrequired",
        standardSubmit: false,
        items: [{
			    xtype: 'customcombobox',
	    		name: 'approverId',
				fieldLabel:getExaminationTranslation('APPROVER'),
				store:'examinationcenters.CenterResponisble',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
	            allowBlank: false,
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            enableKeyEvents  : 'true',
	            hideTrigger:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: '',
			    listConfig: {
			    	listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
        },{
            xtype: 'fieldcontainer',
            width:'95%',
            cls:'windowBtnPos',
	        items: [{
	            xtype: 'button',
	            text: getExaminationTranslation('SAVE'),
	            itemId: 'btnSave',
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true
	        }, {
	            xtype: 'button',
	            text: getExaminationTranslation('CANCEL'),
	            itemId: 'btnCancel',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
        }]
    }]
});