/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.repetitioncompletion.managerepetitioncompletion.DetailSequenceRepeatedGrid',{
    extend: 'Ext.grid.Panel',
    alias: 'widget.detailsequencerepeatedgrid',
    store: 'examinationcenters.repetitioncompletion.DetailSequenceRepeated',
    border: true,
    autoScroll: false,
    width: 462,
    frame:false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
	        xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
		    store : 'examinationcenters.repetitioncompletion.DetailSequenceRepeated',
		    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
		    displayInfo : true
		}]
	}
	],
/*	 tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'
	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    }],*/
    columns: [{
    	header: getExaminationTranslation('SELECT'),
        xtype: 'checkcolumn',
        dataIndex: 'checkDetailSeq',
        width:50
     },{
         header: getExaminationTranslation('DETAILED_SEQUENCE'),
         dataIndex: 'detailSequenceNumber',
         flex:.1,
         sortable: true
     },{
        header: getExaminationTranslation('EQUIVALENT_DETAIL_SEQUENCE'),
        dataIndex: 'detailSequence',
        flex:.1,
        sortable:true,
       // hidden:true,
        editor : {
			 xtype: 'customcombobox',
			 name:'detailSequence',
			 store:'examinationcenters.repetitioncompletion.EquivalentDetailSequence',
			 valueField : 'value',
			 displayField : 'value',
			 typeAhead:true,
			 listeners:{
				 select:function(obj,rec){
					 var data=rec[0].data;
					 var gridModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];	
					 gridModel.set("equivalentDetailSequenceId",data.id);
				 }
			 }
		 },    
	     renderer:function(value,meta){
	    	 if(isNullOrEmpty(value)) {
	            	meta.tdCls = 'gridInputCustomStyle'; 
	            	return getExaminationTranslation('CLICK_TO_ENTER');
	            }else{
	            	return value;
	            }                     
	     }
    }, {
        header: getExaminationTranslation('CONDUCTED_STATUS'),
        dataIndex: 'conductedStatus',
        flex:.1,
        sortable: true,
        hidden:true
    }, {
        header: getExaminationTranslation('COMPLETION_STATUS'),
        dataIndex: 'completionStatus',
        flex:.1,
        sortable: true,
        hidden:true
    }],
    plugins: [{
        ptype : 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(editor , context){
            	var editorField=context.grid.columnManager.columns[context.colIdx].field;
            	var editorStore=editorField.getStore();
            	var selData=editor.grid.getSelectionModel().getSelection()[0];
            	var form=context.grid.ownerCt.getForm();
            	var admissionId=form.findField('admissionId').getValue();
            	editorStore.getProxy().extraParams = {
            		detailSequenceId:selData.data.detailSequenceId,
					admissionId:admissionId
                    };
            	editorStore.load();
            	
            }
          } 
        }]
});
