/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.reports.DetainedStudentReportGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
    alias: 'widget.detainedstudentreportgrid',
    store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.DetainStudentList',
    border: true,
	refreshStoreData:true,
	title : getExaminationTranslation('DETENTION_STUDENT_REPORT'),
    //maxHeight: 700,
    frame:false,
    viewConfig: {
        stripeRows: false
    },
    selType:'checkboxmodel',
    selModel: {
    	mode:'MULTI',
    	showHeaderCheckbox: true,
    	allowDeselect: false,
    	checkOnly : true
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			// store: 'examinationcenters.evaluation.coverageDetails.CoverageDetailsGrid',
            store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.DetainStudentList',
        	emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
   },
    tbar:[
    	 {
    	 	xtype: 'button',
            text: getExaminationTranslation('PERMIT_STUDENT'),
            itemId: 'btnPermitSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind : true
        }, {
    	 	xtype: 'button',
            text: getCommonTranslation('SEND_MESSAGE'),
            itemId: 'sendMessageBtn',
            scale: CONSTANTS.BUTTONSIZE,
            disabled:true
        }
    ],
    columns: [/*{
        header: getExaminationTranslation('ADMISSION_NO'),
        dataIndex: 'admissionId',
        flex:.4,
        hidden:true,
        sortable:true
    },*/{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex:.4,
        hidden:true,
        sortable:true
    },
    {
        header: getExaminationTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        flex:.4,
        hidden:true,
        sortable:true
    },{
        header: getExaminationTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true
    },/* {
        header: getExaminationTranslation('PERIOD_ID'),
        dataIndex: 'periodId',
        flex:.3,
        hidden: true
    }, */{
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        flex:.3,
        hidden: true,
        sortable: true
    },{
        header: getExaminationTranslation('COURSE'),
        dataIndex: 'course',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('DETAILED_SEQUENCE'),
        dataIndex: 'eventName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('ATTENDANCE_PERCENTAGE'),
        dataIndex: 'attendancePercentage',
        flex:.3,
        sortable: true,
    	renderer:function(value,meta,record){
			return value+"%";
		}
    },{
        header: getExaminationTranslation('REASON_FOR_NON_DETENTION'),
        dataIndex: 'reasonForNonDetention',
        flex:.3,
        sortable: true,
        hidden:true
    },{
        header: getExaminationTranslation('REMARKS'),
        dataIndex: 'nonDetentionRemark',
        flex:.3,
        sortable: true,
        hidden:true
    }],
    plugins: [{
   	  ptype : 'cellediting',
   	  clicksToEdit: 1
     }]
});
