/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.reports.ExamLevelReportSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.examlevelreportsearchform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	isMinWidthNotRequired: true,
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
//			width: 256,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:'examinationcenters.reports.ExaminationReportStudentStore',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
    		width: 256,
			name:'studentStatus',
			itemId:'studentStatus',
			fieldLabel:  getCommonTranslation('STATUS'),
			minChars:3,
			typeAhead:false,
			value:true,
			 valueField: 'value',
             displayField: 'name',
			forceSelection:true,
			store:'common.picklist.StudentActiveInactiveStatusStore',
			disabled:false,
    	}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:'examinationcenters.reports.ExamRankReportProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 256,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'examinationcenters.reports.ExamRankReportBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			disabled:true,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
    		xtype: 'customcombobox',
    		name: 'evaluationLevelId',
    		itemId: 'evaluationLevelItemId',
    	    store:'examinationcenters.marksheet.StudentAssessmentEvaluationLevelType',
    		displayField:'value',
    		valueField:'id',
    		width: 256,
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
    		//disabled:true,
    		allowBlank:false
    	}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop:'35px!important',paddingTop:'18px!important'},  
		width:'100%',
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 536
			},
			items:[{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId: 'periodItemId',
				disabled:true,
				store:'examinationcenters.reports.ExamRankReportPeriodStore',
				fieldLabel:getExaminationTranslation('PERIOD'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'sectionId',
				itemId: 'sectionItemId',
				disabled:true,
				store:'attendance.SectionAndFacultyByPeriodID',
				fieldLabel:getExaminationTranslation('SECTION'),
				valueField: 'sectionId',
				displayField: 'sectionCode',
				width: 536,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
			}]

		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'courseId',
				itemId: 'courseItemId',
				store:'examinationcenters.reports.ExaminationReportCourseStore',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				queryParam:'name',
				minChars:3,
				width: 536,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
	        	xtype: 'customcombobox',
	            name: 'courseVariant',
	            itemId:'courseVariantItemId',
	            store:'facilitiesresources.resourcebooking.CourseVariantsListStore',
	            displayField:'code',
	            queryParam:'courseName',
	            valueField:'id',
	            width: 256,
	            minChars:3,
	            typeAhead:false,
	            disabled:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				},
	            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
	        }]
		},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'evaluationPlanId',
				itemId: 'evaluationPlanItemId',
				store:'examinationcenters.reports.ExaminationReportEPStore',
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				hidden:true,
				disabled:true,
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'evaluationTypeId',
				itemId: 'evaluationTypeItemId',
				store:'examinationcenters.evaluation.EvaluationTypeMapped',
				fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				hidden:true,
				disabled:true,
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'evaluationSubTypeId',
				itemId: 'evaluationSubTypeItemId',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSubTypeMapped',
				fieldLabel:getExaminationTranslation('EVALUATION_SUB_TYPE'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				disabled:true,
				hidden:true,
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}
		]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'evaluationMethodId',
				itemId: 'evaluationMethodItemId',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationMethodMapped',
				fieldLabel:getExaminationTranslation('EVALUATION_METHOD_VALUE'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				disabled:true,
				hidden:true,
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'evaluationEventId',
				itemId: 'evaluationEventItemId',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.DetailSequenceEquivalentNo',
				fieldLabel:getExaminationTranslation('EVALUATION_EVENT'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				disabled:true,
				hidden:true,
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'attendanceStatusId',
				itemId: 'attendanceStatusId',
				store:'attendance.ExamAttendanceStatusStore',
				fieldLabel:getExaminationTranslation('ATTENDANCE_STATUS'),
				width: 256,
				displayField : 'value',
				valueField : 'code',
				typeAhead : true,
				editable: false,
				forceSelection : true,
				hidden:true,
				allowBlank:false
			}]
		}],
		listeners:{
			expand: function(myfieldset) {
				var sectionItemId = myfieldset.down('#sectionItemId');
				if(sectionItemId.isDisabled()) {
					Ext.defer(function() {
						sectionItemId.el.dom.querySelector('input').readOnly = true;
					}, 500);
				}
			}
		}
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
