/**
 * @author Bhanu
 */
Ext.define('Academia.view.examinationcenters.reports.GenericRemarkReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.genericremarkreportgrid',
	store :  'examinationcenters.reports.GenericRemarkReportStore',
	title : getExaminationTranslation('GENERIC_REMARK_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.GenericRemarkReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
	columns: [
	{
		header : getEnquiryTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1,
		sortable:true
	},{
		header : getAdmissionTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable:true
	},{
		header : getAdmissionTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable:true
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable:true
	},{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1,
		sortable:true
	},{
		header : getExaminationTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1,
		sortable:true
	},{
		header :getExaminationTranslation('LEVEL_NAME'),
		dataIndex : 'levelName',
		flex : 1,
		sortable:true
	},{
		header : getProgramandcourseTranslation('ESR_NO_OF_STUDENTS'),
		dataIndex : 'noOfStudent',
		flex : 1,
		sortable:true
	},{
		header : getExaminationTranslation('GENERIC_REMARK'), 
		dataIndex : 'genericRemark',
		flex : 1,
		sortable:true
	},{
		header : getExaminationTranslation('GENERIC_REMARK_PROVIDED_BY'), 
		dataIndex : 'genericRemarkProvidedBy',
		flex : 1,
		sortable:true
	}]
});
