/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.reports.GradeAverageReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.gradeaveragereportgrid',
	store :  'examinationcenters.reports.GradeAverageReportGridStore',
	title : getExaminationTranslation('GRADE_AVERAGE_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.GradeAverageReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
   tbar: [{
		xtype: 'button',
		itemId: 'gradeAverageExportReport',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		disabled: false
	}],
	columns: [
	{
		header : getExaminationTranslation('COURSE_CODE'),
		dataIndex : 'courseCode',
		flex : 1,
		sortable:true
	},{
        header: getExaminationTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex : 1,
        sortable:true
    },{
        header: getProgramandcourseTranslation('ESR_NO_OF_STUDENTS'),
        dataIndex: 'noOfStudent',
        flex : 1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.raw.noOfStudent)){
        		return "<a href='#'>"+record.raw.noOfStudent+"</a>";
        	}else{
        		return "-";
        	}
        }  
    },{
    	header: getExaminationTranslation('SECTION_NAME'),
        dataIndex: 'sectionName',
        hidden: true,
        flex : 1,
        sortable: true  
    },{
        header: getExaminationTranslation('EVALUATION_LEVEL_NAME'),
        dataIndex: 'assessmentLevelName',
        flex : 1,
        sortable: true
    },{
        header: getExaminationTranslation('AVERAGE_MARKS'),
        dataIndex: 'averageMarks',
        flex : 1,
        sortable: true
    }]
});
