/**
 * @author Manas
 */
Ext.define('Academia.view.examinationcenters.reports.GradeRosterReportFilterCoreErp', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.graderosterreportfiltercoreerp',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    isMinWidthNotRequired: true,
    defaults: {
        labelAlign: 'top',
        width: 226
    },

    // ✅ Reusable helper for consistent listConfig
    initComponent: function () {
        var me = this;

        function getDefaultListConfig(displayField) {
            return {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">{' + (displayField || 'value') + '}</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            };
        }

        me.items = [
            // ---------------------------------------------------------------
            // 1. Intake Year + Academic Term + Program
            // ---------------------------------------------------------------
            {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: { labelAlign: 'top', width: 226 },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('INTAKE_YEAR'),
                    name: 'intakeYear',
                    itemId: 'intakeYear',
                    displayField: 'value',
                    valueField: 'id',
                    typeAhead: true,
                    forceSelection: true,
                    minChars: 3,
                    listConfig: getDefaultListConfig('code'),
                    listeners: {
                        beforerender: function (combo) {
                            var store = Ext.create('Academia.store.common.IntakeYearStoreByBatchId');
                            combo.bindStore(store);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
                    name: 'academicTerm',
                    itemId: 'academicTerm',
                    displayField: 'value',
                    valueField: 'id',
                    typeAhead: true,
                    forceSelection: true,
                    listConfig: getDefaultListConfig('value'),
                    listeners: {
                        beforerender: function (combo) {
                            var store = Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
                            combo.bindStore(store);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
                    name: 'programId',
                    itemId: 'programItemId',
                    store: 'examinationcenters.reports.ExamGradeReportProgramStore',
                    displayField: 'valueSecondValue',
                    valueField: 'id',
                    queryParam: 'name',
                    minChars: 3,
                    typeAhead: false,
                    forceSelection: true,
                    allowBlank: false,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    listConfig: getDefaultListConfig('valueSecondValue'),
                    listeners: {
                        select: function (combo, record) {
                            var form = combo.up('form');
                            var batchCombo = form.down('#batchItemId');
                            var periodCombo = form.down('#periodItemId');
                            var courseCombo = form.down('#courseItemId');
                            batchCombo.setDisabled(false);
                            periodCombo.setDisabled(false);
                            courseCombo.setDisabled(false);
                        }
                    }
                }]
            },

            // ---------------------------------------------------------------
            // 2. Batch + Period
            // ---------------------------------------------------------------
            {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: { labelAlign: 'top', width: 226 },
                items: [{
                    xtype: 'customcombobox',
                    name: 'batchId',
                    itemId: 'batchItemId',
                    fieldLabel: getExaminationTranslation('BATCH'),
                    store: 'examinationcenters.reports.ExaminationReportBatchStore',
                    valueField: 'id',
                    displayField: 'value',
					queryParam: 'name',
                    disabled: true,
                    listConfig: getDefaultListConfig('value'),
                    listeners: {
                        select: function (combo) {
                            var form = combo.up('form');
                            var periodCombo = form.down('#periodItemId');
                            periodCombo.setDisabled(false);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'periodId',
                    itemId: 'periodItemId',
                    fieldLabel: getExaminationTranslation('PERIOD'),
                    store: 'examinationcenters.reports.ExaminationReportPeriodStore',
                    valueField: 'id',
                    displayField: 'value',
                    disabled: true,
					queryParam: 'name',
                    listConfig: getDefaultListConfig('value'),
                    listeners: {
                        select: function (combo) {
                            var form = combo.up('form');
                            var courseCombo = form.down('#courseItemId');
                            courseCombo.setDisabled(false);
                        }
                    }
                }]
            },

            // ---------------------------------------------------------------
            // 3. Course + Course Variant
            // ---------------------------------------------------------------
            {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: { labelAlign: 'top', width: 226 },
                items: [{
                    xtype: 'customcombobox',
                    name: 'courseId',
                    itemId: 'courseItemId',
                    store: 'examinationcenters.reports.ExaminationReportCourseStore',
                    fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
                    valueField: 'id',
                    displayField: 'value',
                    queryParam: 'name',
                    disabled: true,
                    minChars: 3,
                    forceSelection: true,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    listConfig: getDefaultListConfig('value'),
                    listeners: {
                        select: function (combo) {
                            var form = combo.up('form');
                            var variantCombo = form.down('#courseVariantItemId');
                            variantCombo.setDisabled(false);
                        }
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'courseVariant',
                    itemId: 'courseVariantItemId',
                    fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
                    store: Ext.create('Academia.store.facilitiesresources.resourcebooking.CourseVariantsListStore'),
                    displayField: 'code',
                    queryParam: 'courseName',
                    valueField: 'id',
                    disabled: true,
                    listConfig: getDefaultListConfig('code')
                }]
            },

            // ---------------------------------------------------------------
            // 4. Faculty + Student + Status
            // ---------------------------------------------------------------
            {
                xtype: 'fieldcontainer',
                width: '100%',
                layout: 'hbox',
                defaults: { labelAlign: 'top', width: 226 },
                items: [{
                    xtype: 'customcombobox',
                    name: 'facultyName',
                    itemId: 'facultyItemId',
                    store: 'coursetransaction.facultytopicassignment.AssignFacultyStore',
                    fieldLabel: getExaminationTranslation('FACULTY'),
                    valueField: 'id',
                    displayField: 'value',
                    queryParam: 'codeOrName',
                    minChars: 3,
                    disabled: false,
                    listConfig: getDefaultListConfig('value'),
                    listeners: {
                        /*select: function (combo, records) {
                            var form = combo.up('form');
                            var programCombo = form.down('#programItemId');
                            var courseCombo = form.down('#courseItemId');
                            if (!records || records.length === 0) return;
                            var personId = records[0].raw.personId;
                            if (programCombo && !programCombo.getValue()) {
                                courseCombo.reset();
                                programCombo.setValue(personId);
                                var programRecord = programCombo.getStore().findRecord('id', personId);
                                if (programRecord) {
                                    programCombo.fireEvent('select', programCombo, [programRecord], {
                                        isFacultyTriggered: true
                                    });
                                } 
                            }
                        }*/
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'studentName',
                    itemId: 'studentItemId',
                    store: 'examinationcenters.reports.ExaminationReportStudentStore',
                    fieldLabel: getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
                    valueField: 'id',
                    displayField: 'valueCode',
                    queryParam: 'name',
                    minChars: 3,
                    disabled: false,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    listConfig: getDefaultListConfig('valueCode'),
                    listeners: {
						select: function (combo, recs) {
						    if (!recs.length) return;

						    var f = combo.up('form'),
						        p = f.down('#programItemId'),
						        c = f.down('#courseItemId'),
						        sid = recs[0].raw.id;   // ✅ studentId

						    if (!p) return;

						    p.reset();
						    c.reset();

						    p.getStore().reload({
						        params: { studentId: sid },
						        callback: function (records, operation, success) {
						            if (success && records && records.length > 0) {
						                var firstRec = records[0];          // ✅ first record
						                var id = firstRec.get('id');        // ✅ its id
						                p.setValue(id);
						                p.fireEvent('select', p, [firstRec], { isStudentTriggered: true });
						            }
						        }
						    });
						}
 
                    }
                }, {
                    xtype: 'customcombobox',
                    name: 'studentStatus',
                    itemId: 'studentStatus',
                    fieldLabel: getCommonTranslation('STATUS'),
                    valueField: 'value',
                    displayField: 'name',
                    store: 'common.picklist.StudentActiveInactiveStatusStore',
                    value: true,
                    listConfig: getDefaultListConfig('name')
                }]
            },

            // ---------------------------------------------------------------
            // 5. Buttons
            // ---------------------------------------------------------------
            {
                xtype: 'fieldcontainer',
                width : 'auto',
        		cls: 'customSearchPanelBtnsFieldContainerCls',
        		layout: 'hbox',
                items: [{
                    xtype: 'button',
                    text: getCommonTranslation('SEARCH'),
                    itemId: 'searchBtn',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE,
                    formBind: true
                }, {
                    xtype: 'button',
                    text: getCommonTranslation('RESET'),
                    itemId: 'resetBtn',
                    ui: 'CustomBtnCancel',
                    scale: CONSTANTS.BUTTONSIZE
                }]
            }
        ];

        me.callParent(arguments);
    }
});