/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.GradeRosterReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.graderosterreportgrid',
	store: 'examinationcenters.reports.GradeRosterReportStore',
	title: getExaminationTranslation('GRADE_ROSTER_REPORT_LIST'),
	border: true,
	refreshStoreData:true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},  
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.reports.GradeRosterReportStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;
		 if (portalId == 1) {
            this.headerFix = {
                headerFix: true,
                portalIdsWithStructure: {
                    'examinationreports': 1
                }
            };
        } else{
			this.headerFix = {  
                headerFix: true,
                portalIdsWithStructure: {
                    'personinfofacultyportal':2
                }
            };
        }                  
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
    tbar : [{
	    xtype : 'button',
	    itemId : 'exportGradeRosterReportsId',
	    tooltip : getExaminationTranslation('EXPORT_GRADE_ROSTER_REPORT'),
	    text : getExaminationTranslation('EXPORT_GRADE_ROSTER_REPORT'),
	    formBind:true,
	}],
	columns: [{
		header:  getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			var baseController=Academia.app.getController('Academia.controller.base.BaseController');
			if(!isNullOrEmpty(value)) {
				if(baseController.getCurrentLoggedPortalId()==2 || record.data.studentId == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .1
	},{
		header:  getCommonTranslation('PROGRAM_NAME'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation('COURSE'),
		dataIndex: 'courseName',
		flex:.3,
		sortable:true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantCode',
		flex : .3,
		hidden :false
	},{
		header : getCommonTranslation('CREDIT'),
		dataIndex : 'courseCredit',
		flex : .1,
		hidden :false
	},{
		header:  getCommonTranslation('FACULTY_NAME'),
		dataIndex: 'facultyName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getCommonTranslation('OBTAINED_MARKS'),
		dataIndex: 'effectiveMarks',
		flex:.1,
		sortable:true
	}, {
		header:  getCommonTranslation('OBTAINED_GRADE'),
		dataIndex: 'grade',
		flex:.1,
		sortable:true
	},
	{
		header:  getCommonTranslation('GRADE_POINT'),
		dataIndex: 'gradePoint',
		flex:.1,
		sortable:true
	},
	{
		header:  getCommonTranslation('EXAM_RESULT'),
		dataIndex: 'examResult',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value))
				return getExaminationTranslation(value);
			else
				return '';
		}
	}]
});
